/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.time.Clock;
import java.util.Optional;
import java.util.Set;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobReferenceSource;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.server.blob.deduplication.BlobGCTask;
import org.apache.james.server.blob.deduplication.GenerationAwareBlobId;
import org.apache.james.task.Task;
import org.apache.james.task.TaskManager;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.tasks.TaskFromRequest;
import org.apache.james.webadmin.utils.JsonTransformer;
import spark.Request;
import spark.ResponseTransformer;
import spark.Service;

public class BlobRoutes
implements Routes {
    public static final String BASE_PATH = "/blobs";
    public static final int EXPECTED_BLOB_COUNT_DEFAULT = 1000000;
    public static final double ASSOCIATED_PROBABILITY_DEFAULT = 0.01;
    private final TaskManager taskManager;
    private final JsonTransformer jsonTransformer;
    private final Clock clock;
    private final BlobStoreDAO blobStoreDAO;
    private final BucketName bucketName;
    private final Set<BlobReferenceSource> blobReferenceSources;
    private final GenerationAwareBlobId.Configuration generationAwareBlobIdConfiguration;
    private final BlobId.Factory generationAwareBlobIdFactory;

    @Inject
    public BlobRoutes(TaskManager taskManager, JsonTransformer jsonTransformer, Clock clock, BlobStoreDAO blobStoreDAO, @Named(value="defaultBucket") BucketName defaultBucketName, Set<BlobReferenceSource> blobReferenceSources, GenerationAwareBlobId.Configuration generationAwareBlobIdConfiguration, BlobId.Factory generationAwareBlobIdFactory) {
        this.taskManager = taskManager;
        this.jsonTransformer = jsonTransformer;
        this.clock = clock;
        this.blobStoreDAO = blobStoreDAO;
        this.bucketName = defaultBucketName;
        this.blobReferenceSources = blobReferenceSources;
        this.generationAwareBlobIdConfiguration = generationAwareBlobIdConfiguration;
        this.generationAwareBlobIdFactory = generationAwareBlobIdFactory;
    }

    public String getBasePath() {
        return BASE_PATH;
    }

    public void define(Service service) {
        TaskFromRequest gcUnreferencedTaskRequest = this::gcUnreferenced;
        service.delete(BASE_PATH, gcUnreferencedTaskRequest.asRoute(this.taskManager), (ResponseTransformer)this.jsonTransformer);
    }

    public Task gcUnreferenced(Request request) {
        Preconditions.checkArgument((boolean)Optional.ofNullable(request.queryParams("scope")).filter("unreferenced"::equals).isPresent(), (Object)"'scope' is missing or must be 'unreferenced'");
        int expectedBlobCount = BlobRoutes.getExpectedBlobCount(request).orElse(1000000);
        Optional<Integer> deletionWindowSize = BlobRoutes.getDeletionWindowSize(request);
        double associatedProbability = BlobRoutes.getAssociatedProbability(request).orElse(0.01);
        return BlobGCTask.builder().blobStoreDAO(this.blobStoreDAO).generationAwareBlobIdFactory(this.generationAwareBlobIdFactory).generationAwareBlobIdConfiguration(this.generationAwareBlobIdConfiguration).blobReferenceSource(this.blobReferenceSources).bucketName(this.bucketName).clock(this.clock).expectedBlobCount(expectedBlobCount).associatedProbability(associatedProbability).deletionWindowSize(deletionWindowSize).build();
    }

    private static Optional<Integer> getExpectedBlobCount(Request req) {
        try {
            return Optional.ofNullable(req.queryParams("expectedBlobCount")).map(Integer::parseInt).map(expectedBlobCount -> {
                Preconditions.checkArgument((expectedBlobCount > 0 ? 1 : 0) != 0, (Object)"'expectedBlobCount' must be strictly positive");
                return expectedBlobCount;
            });
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("'expectedBlobCount' must be numeric");
        }
    }

    private static Optional<Integer> getDeletionWindowSize(Request req) {
        try {
            return Optional.ofNullable(req.queryParams("deletionWindowSize")).map(Integer::parseInt).map(expectedBlobCount -> {
                Preconditions.checkArgument((expectedBlobCount > 0 ? 1 : 0) != 0, (Object)"'deletionWindowSize' must be strictly positive");
                return expectedBlobCount;
            });
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("'deletionWindowSize' must be numeric");
        }
    }

    private static Optional<Double> getAssociatedProbability(Request req) {
        try {
            return Optional.ofNullable(req.queryParams("associatedProbability")).map(Double::parseDouble).map(associatedProbability -> {
                Preconditions.checkArgument((associatedProbability > 0.0 && associatedProbability < 1.0 ? 1 : 0) != 0, (Object)"'associatedProbability' must be greater than 0.0 and smaller than 1.0");
                return associatedProbability;
            });
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("'associatedProbability' must be numeric");
        }
    }
}

