/*
 * Decompiled with CFR 0.152.
 */
package reactor.bool;

import reactor.core.publisher.Mono;

public final class BooleanUtils {
    private BooleanUtils() {
    }

    public static Mono<Boolean> not(Mono<Boolean> value) {
        return value.map(bool -> bool == false);
    }

    public static Mono<Boolean> and(Mono<Boolean> value1, Mono<Boolean> value2) {
        return Mono.zip(value1, value2, (bool1, bool2) -> bool1 != false && bool2 != false);
    }

    public static Mono<Boolean> xor(Mono<Boolean> value1, Mono<Boolean> value2) {
        return Mono.zip(value1, value2, (bool1, bool2) -> bool1 != bool2 && (bool1 != false || bool2 != false));
    }

    public static Mono<Boolean> or(Mono<Boolean> value1, Mono<Boolean> value2) {
        return Mono.zip(value1, value2, (bool1, bool2) -> bool1 != false || bool2 != false);
    }

    public static Mono<Boolean> nand(Mono<Boolean> value1, Mono<Boolean> value2) {
        return BooleanUtils.not(BooleanUtils.and(value1, value2));
    }

    public static Mono<Boolean> nor(Mono<Boolean> value1, Mono<Boolean> value2) {
        return BooleanUtils.not(BooleanUtils.or(value1, value2));
    }
}

