/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.quota;

import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.Domain;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.mailbox.cassandra.quota.CassandraGlobalMaxQuotaDao;
import org.apache.james.mailbox.cassandra.quota.CassandraPerDomainMaxQuotaDao;
import org.apache.james.mailbox.cassandra.quota.CassandraPerUserMaxQuotaDao;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.Limits;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Deprecated
public class CassandraPerUserMaxQuotaManagerV1
implements MaxQuotaManager {
    private final CassandraPerUserMaxQuotaDao perUserQuota;
    private final CassandraPerDomainMaxQuotaDao perDomainQuota;
    private final CassandraGlobalMaxQuotaDao globalQuota;

    @Inject
    public CassandraPerUserMaxQuotaManagerV1(CassandraPerUserMaxQuotaDao perUserQuota, CassandraPerDomainMaxQuotaDao domainQuota, CassandraGlobalMaxQuotaDao globalQuota) {
        this.perUserQuota = perUserQuota;
        this.perDomainQuota = domainQuota;
        this.globalQuota = globalQuota;
    }

    public void setMaxStorage(QuotaRoot quotaRoot, QuotaSizeLimit maxStorageQuota) {
        this.setMaxStorageReactive(quotaRoot, maxStorageQuota).block();
    }

    public Mono<Void> setMaxStorageReactive(QuotaRoot quotaRoot, QuotaSizeLimit maxStorageQuota) {
        return this.perUserQuota.setMaxStorage(quotaRoot, maxStorageQuota);
    }

    public void setMaxMessage(QuotaRoot quotaRoot, QuotaCountLimit maxMessageCount) {
        this.setMaxMessageReactive(quotaRoot, maxMessageCount).block();
    }

    public Mono<Void> setMaxMessageReactive(QuotaRoot quotaRoot, QuotaCountLimit maxMessageCount) {
        return this.perUserQuota.setMaxMessage(quotaRoot, maxMessageCount);
    }

    public void setDomainMaxMessage(Domain domain, QuotaCountLimit count) {
        this.setDomainMaxMessageReactive(domain, count).block();
    }

    public Mono<Void> setDomainMaxMessageReactive(Domain domain, QuotaCountLimit count) {
        return this.perDomainQuota.setMaxMessage(domain, count);
    }

    public void setDomainMaxStorage(Domain domain, QuotaSizeLimit size) {
        this.setDomainMaxStorageReactive(domain, size).block();
    }

    public Mono<Void> setDomainMaxStorageReactive(Domain domain, QuotaSizeLimit size) {
        return this.perDomainQuota.setMaxStorage(domain, size);
    }

    public void removeDomainMaxMessage(Domain domain) {
        this.removeDomainMaxMessageReactive(domain).block();
    }

    public Mono<Void> removeDomainMaxMessageReactive(Domain domain) {
        return this.perDomainQuota.removeMaxMessage(domain);
    }

    public void removeDomainMaxStorage(Domain domain) {
        this.removeDomainMaxStorageReactive(domain).block();
    }

    public Mono<Void> removeDomainMaxStorageReactive(Domain domain) {
        return this.perDomainQuota.removeMaxStorage(domain);
    }

    public Optional<QuotaCountLimit> getDomainMaxMessage(Domain domain) {
        return this.getDomainMaxMessageReactive(domain).blockOptional();
    }

    public Mono<QuotaCountLimit> getDomainMaxMessageReactive(Domain domain) {
        return this.perDomainQuota.getMaxMessage(domain);
    }

    public Optional<QuotaSizeLimit> getDomainMaxStorage(Domain domain) {
        return this.getDomainMaxStorageReactive(domain).blockOptional();
    }

    public Mono<QuotaSizeLimit> getDomainMaxStorageReactive(Domain domain) {
        return this.perDomainQuota.getMaxStorage(domain);
    }

    public void removeMaxMessage(QuotaRoot quotaRoot) {
        this.removeMaxMessageReactive(quotaRoot).block();
    }

    public Mono<Void> removeMaxMessageReactive(QuotaRoot quotaRoot) {
        return this.perUserQuota.removeMaxMessage(quotaRoot);
    }

    public void removeMaxStorage(QuotaRoot quotaRoot) {
        this.removeMaxStorageReactive(quotaRoot).block();
    }

    public Mono<Void> removeMaxStorageReactive(QuotaRoot quotaRoot) {
        return this.perUserQuota.removeMaxStorage(quotaRoot);
    }

    public void setGlobalMaxStorage(QuotaSizeLimit globalMaxStorage) {
        this.setGlobalMaxStorageReactive(globalMaxStorage).block();
    }

    public Mono<Void> setGlobalMaxStorageReactive(QuotaSizeLimit globalMaxStorage) {
        return this.globalQuota.setGlobalMaxStorage(globalMaxStorage);
    }

    public void removeGlobalMaxStorage() {
        this.removeGlobalMaxStorageReactive().block();
    }

    public Mono<Void> removeGlobalMaxStorageReactive() {
        return this.globalQuota.removeGlobaltMaxStorage();
    }

    public void setGlobalMaxMessage(QuotaCountLimit globalMaxMessageCount) {
        this.setGlobalMaxMessageReactive(globalMaxMessageCount).block();
    }

    public Mono<Void> setGlobalMaxMessageReactive(QuotaCountLimit globalMaxMessageCount) {
        return this.globalQuota.setGlobalMaxMessage(globalMaxMessageCount);
    }

    public void removeGlobalMaxMessage() {
        this.removeGlobalMaxMessageReactive().block();
    }

    public Mono<Void> removeGlobalMaxMessageReactive() {
        return this.globalQuota.removeGlobalMaxMessage();
    }

    public Optional<QuotaSizeLimit> getGlobalMaxStorage() {
        return this.getGlobalMaxStorageReactive().blockOptional();
    }

    public Mono<QuotaSizeLimit> getGlobalMaxStorageReactive() {
        return this.globalQuota.getGlobalMaxStorage();
    }

    public Optional<QuotaCountLimit> getGlobalMaxMessage() {
        return this.getGlobalMaxMessageReactive().blockOptional();
    }

    public Mono<QuotaCountLimit> getGlobalMaxMessageReactive() {
        return this.globalQuota.getGlobalMaxMessage();
    }

    public Map<Quota.Scope, QuotaCountLimit> listMaxMessagesDetails(QuotaRoot quotaRoot) {
        return (Map)this.listMaxMessagesDetailsReactive(quotaRoot).block();
    }

    public Mono<Map<Quota.Scope, QuotaCountLimit>> listMaxMessagesDetailsReactive(QuotaRoot quotaRoot) {
        Publisher[] publisherArray = new Publisher[3];
        publisherArray[0] = this.perUserQuota.getMaxMessage(quotaRoot).map(limit -> Pair.of((Object)Quota.Scope.User, (Object)limit));
        publisherArray[1] = Mono.justOrEmpty((Optional)quotaRoot.getDomain()).flatMap(this.perDomainQuota::getMaxMessage).map(limit -> Pair.of((Object)Quota.Scope.Domain, (Object)limit));
        publisherArray[2] = this.globalQuota.getGlobalMaxMessage().map(limit -> Pair.of((Object)Quota.Scope.Global, (Object)limit));
        return Flux.merge((Publisher[])publisherArray).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
    }

    public Map<Quota.Scope, QuotaSizeLimit> listMaxStorageDetails(QuotaRoot quotaRoot) {
        return (Map)this.listMaxStorageDetailsReactive(quotaRoot).block();
    }

    public Mono<Map<Quota.Scope, QuotaSizeLimit>> listMaxStorageDetailsReactive(QuotaRoot quotaRoot) {
        Publisher[] publisherArray = new Publisher[3];
        publisherArray[0] = this.perUserQuota.getMaxStorage(quotaRoot).map(limit -> Pair.of((Object)Quota.Scope.User, (Object)limit));
        publisherArray[1] = Mono.justOrEmpty((Optional)quotaRoot.getDomain()).flatMap(this.perDomainQuota::getMaxStorage).map(limit -> Pair.of((Object)Quota.Scope.Domain, (Object)limit));
        publisherArray[2] = this.globalQuota.getGlobalMaxStorage().map(limit -> Pair.of((Object)Quota.Scope.Global, (Object)limit));
        return Flux.merge((Publisher[])publisherArray).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
    }

    public MaxQuotaManager.QuotaDetails quotaDetails(QuotaRoot quotaRoot) {
        return (MaxQuotaManager.QuotaDetails)this.quotaDetailsReactive(quotaRoot).block();
    }

    public Mono<MaxQuotaManager.QuotaDetails> quotaDetailsReactive(QuotaRoot quotaRoot) {
        return Mono.zip(this.perUserQuota.getLimits(quotaRoot), (Mono)Mono.justOrEmpty((Optional)quotaRoot.getDomain()).flatMap(this.perDomainQuota::getLimits).switchIfEmpty(Mono.just((Object)Limits.empty())), this.globalQuota.getGlobalLimits()).map(tuple -> new MaxQuotaManager.QuotaDetails(this.countDetails((Limits)tuple.getT1(), (Limits)tuple.getT2(), ((Limits)tuple.getT3()).getCountLimit()), this.sizeDetails((Limits)tuple.getT1(), (Limits)tuple.getT2(), ((Limits)tuple.getT3()).getSizeLimit())));
    }

    private Map<Quota.Scope, QuotaSizeLimit> sizeDetails(Limits userLimits, Limits domainLimits, Optional<QuotaSizeLimit> globalLimits) {
        return (Map)Stream.of(userLimits.getSizeLimit().stream().map(limit -> Pair.of((Object)Quota.Scope.User, (Object)limit)), domainLimits.getSizeLimit().stream().map(limit -> Pair.of((Object)Quota.Scope.Domain, (Object)limit)), globalLimits.stream().map(limit -> Pair.of((Object)Quota.Scope.Global, (Object)limit))).flatMap(Function.identity()).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
    }

    private Map<Quota.Scope, QuotaCountLimit> countDetails(Limits userLimits, Limits domainLimits, Optional<QuotaCountLimit> globalLimits) {
        return (Map)Stream.of(userLimits.getCountLimit().stream().map(limit -> Pair.of((Object)Quota.Scope.User, (Object)limit)), domainLimits.getCountLimit().stream().map(limit -> Pair.of((Object)Quota.Scope.Domain, (Object)limit)), globalLimits.stream().map(limit -> Pair.of((Object)Quota.Scope.Global, (Object)limit))).flatMap(Function.identity()).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
    }
}

