/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Long;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetConnectionIDExtendedResult
extends ExtendedResult {
    private static final long serialVersionUID = -3161975076326146250L;
    private final long connectionID;

    public GetConnectionIDExtendedResult(@NotNull ExtendedResult extendedResult) throws LDAPException {
        super(extendedResult);
        ASN1OctetString value = extendedResult.getValue();
        if (value == null) {
            this.connectionID = -1L;
            return;
        }
        try {
            ASN1Element e = ASN1Element.decode(value.getValue());
            this.connectionID = ASN1Long.decodeAsLong(e).longValue();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_CONN_ID_RESPONSE_VALUE_NOT_INT.get(), e);
        }
    }

    public GetConnectionIDExtendedResult(int messageID, @NotNull ResultCode resultCode, @Nullable String diagnosticMessage, @Nullable String matchedDN, @Nullable String[] referralURLs, @Nullable Long connectionID, @Nullable Control[] responseControls) {
        super(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, null, GetConnectionIDExtendedResult.encodeValue(connectionID), responseControls);
        this.connectionID = connectionID == null ? -1L : connectionID;
    }

    @Nullable
    private static ASN1OctetString encodeValue(@Nullable Long connectionID) {
        if (connectionID == null || connectionID < 0L) {
            return null;
        }
        return new ASN1OctetString(new ASN1Long(connectionID).encode());
    }

    public long getConnectionID() {
        return this.connectionID;
    }

    @Override
    @NotNull
    public String getExtendedResultName() {
        return ExtOpMessages.INFO_EXTENDED_RESULT_NAME_GET_CONNECTION_ID.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        Control[] controls;
        String[] referralURLs;
        String matchedDN;
        String diagnosticMessage;
        buffer.append("GetConnectionIDExtendedResult(connectionID=");
        buffer.append(this.connectionID);
        buffer.append(", resultCode=");
        buffer.append(this.getResultCode());
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(messageID);
        }
        if ((diagnosticMessage = this.getDiagnosticMessage()) != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()) != null && referralURLs.length > 0) {
            buffer.append(", referralURLs={ '");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append("', '");
                }
                buffer.append(referralURLs[i]);
            }
            buffer.append("' }");
        }
        if ((controls = this.getResponseControls()).length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

