/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.activemq;

import jakarta.inject.Inject;
import jakarta.jms.ConnectionFactory;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.queue.activemq.ActiveMQCacheableMailQueue;
import org.apache.james.queue.activemq.EmbeddedActiveMQ;
import org.apache.james.queue.activemq.metric.ActiveMQMetricCollector;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.jms.JMSMailQueueFactory;

public class ActiveMQMailQueueFactory
extends JMSMailQueueFactory {
    private boolean useBlob = true;
    private final ActiveMQMetricCollector activeMQMetricCollector;

    public ActiveMQMailQueueFactory(ConnectionFactory connectionFactory, MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory, MetricFactory metricFactory, GaugeRegistry gaugeRegistry, ActiveMQMetricCollector activeMQMetricCollector) {
        super(connectionFactory, mailQueueItemDecoratorFactory, metricFactory, gaugeRegistry);
        this.activeMQMetricCollector = activeMQMetricCollector;
    }

    @Inject
    public ActiveMQMailQueueFactory(EmbeddedActiveMQ embeddedActiveMQ, MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory, MetricFactory metricFactory, GaugeRegistry gaugeRegistry, ActiveMQMetricCollector activeMQMetricCollector) {
        this(embeddedActiveMQ.getConnectionFactory(), mailQueueItemDecoratorFactory, metricFactory, gaugeRegistry, activeMQMetricCollector);
    }

    public void setUseBlobMessages(boolean useBlob) {
        this.useBlob = useBlob;
    }

    protected ManageableMailQueue createCacheableMailQueue(MailQueueName name) {
        this.activeMQMetricCollector.collectQueueStatistics(name);
        return new ActiveMQCacheableMailQueue(this.connectionFactory, this.mailQueueItemDecoratorFactory, name, this.useBlob, this.metricFactory, this.gaugeRegistry);
    }
}

