/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.user;

import java.util.List;
import org.apache.james.core.Username;
import org.apache.james.mailbox.postgres.user.PostgresSubscriptionDAO;
import org.apache.james.mailbox.store.user.SubscriptionMapper;
import org.apache.james.mailbox.store.user.model.Subscription;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresSubscriptionMapper
implements SubscriptionMapper {
    private final PostgresSubscriptionDAO subscriptionDAO;

    public PostgresSubscriptionMapper(PostgresSubscriptionDAO subscriptionDAO) {
        this.subscriptionDAO = subscriptionDAO;
    }

    public void save(Subscription subscription) {
        this.saveReactive(subscription).block();
    }

    public List<Subscription> findSubscriptionsForUser(Username user) {
        return (List)this.findSubscriptionsForUserReactive(user).collectList().block();
    }

    public void delete(Subscription subscription) {
        this.deleteReactive(subscription).block();
    }

    public Mono<Void> saveReactive(Subscription subscription) {
        return this.subscriptionDAO.save(subscription.getUser().asString(), subscription.getMailbox());
    }

    public Flux<Subscription> findSubscriptionsForUserReactive(Username user) {
        return this.subscriptionDAO.findMailboxByUser(user.asString()).map(mailbox -> new Subscription(user, mailbox));
    }

    public Mono<Void> deleteReactive(Subscription subscription) {
        return this.subscriptionDAO.delete(subscription.getUser().asString(), subscription.getMailbox());
    }
}

