/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.mail;

import java.time.Duration;
import java.util.function.Function;
import org.apache.james.core.Username;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.postgres.mail.PostgresACLUpsertException;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMailboxDAO;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

public class PostgresMailboxMapper
implements MailboxMapper {
    private final PostgresMailboxDAO postgresMailboxDAO;

    public PostgresMailboxMapper(PostgresMailboxDAO postgresMailboxDAO) {
        this.postgresMailboxDAO = postgresMailboxDAO;
    }

    public Mono<Mailbox> create(MailboxPath mailboxPath, UidValidity uidValidity) {
        return this.postgresMailboxDAO.create(mailboxPath, uidValidity);
    }

    public Mono<MailboxId> rename(Mailbox mailbox) {
        return this.postgresMailboxDAO.rename(mailbox);
    }

    public Mono<Void> delete(Mailbox mailbox) {
        return this.postgresMailboxDAO.delete(mailbox.getMailboxId());
    }

    public Mono<Mailbox> findMailboxByPath(MailboxPath mailboxName) {
        return this.postgresMailboxDAO.findMailboxByPath(mailboxName).map(Function.identity());
    }

    public Mono<Mailbox> findMailboxById(MailboxId mailboxId) {
        return this.postgresMailboxDAO.findMailboxById(mailboxId).map(Function.identity());
    }

    public Flux<Mailbox> findMailboxWithPathLike(MailboxQuery.UserBound query) {
        return this.postgresMailboxDAO.findMailboxWithPathLike(query).map(Function.identity());
    }

    public Mono<Boolean> hasChildren(Mailbox mailbox, char delimiter) {
        return this.postgresMailboxDAO.hasChildren(mailbox, delimiter);
    }

    public Flux<Mailbox> list() {
        return this.postgresMailboxDAO.getAll().map(Function.identity());
    }

    public Flux<Mailbox> findNonPersonalMailboxes(Username userName, MailboxACL.Right right) {
        return this.postgresMailboxDAO.findMailboxesByUsername(userName).filter(postgresMailbox -> ((MailboxACL.Rfc4314Rights)postgresMailbox.getACL().getEntries().get(MailboxACL.EntryKey.createUserEntryKey((Username)userName))).contains(right)).map(Function.identity());
    }

    public Mono<ACLDiff> updateACL(Mailbox mailbox, MailboxACL.ACLCommand mailboxACLCommand) {
        return this.postgresMailboxDAO.getACL(mailbox.getMailboxId()).flatMap(pairMailboxACLAndVersion -> {
            try {
                MailboxACL newACL = ((MailboxACL)pairMailboxACLAndVersion.getLeft()).apply(mailboxACLCommand);
                return this.postgresMailboxDAO.upsertACL(mailbox.getMailboxId(), newACL, (Long)pairMailboxACLAndVersion.getRight()).thenReturn((Object)ACLDiff.computeDiff((MailboxACL)((MailboxACL)pairMailboxACLAndVersion.getLeft()), (MailboxACL)newACL));
            }
            catch (UnsupportedRightException e) {
                throw new RuntimeException(e);
            }
        }).retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofMillis(100L)).filter(throwable -> throwable instanceof PostgresACLUpsertException));
    }

    public Mono<ACLDiff> setACL(Mailbox mailbox, MailboxACL mailboxACL) {
        return this.postgresMailboxDAO.upsertACL(mailbox.getMailboxId(), mailboxACL).thenReturn((Object)ACLDiff.computeDiff((MailboxACL)mailbox.getACL(), (MailboxACL)mailboxACL));
    }
}

