/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.mail;

import java.util.UUID;
import org.apache.james.backends.postgres.PostgresDataDefinition;
import org.apache.james.backends.postgres.PostgresIndex;
import org.apache.james.backends.postgres.PostgresTable;
import org.jooq.Binding;
import org.jooq.Constraint;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.SQLDataType;
import org.jooq.postgres.extensions.bindings.HstoreBinding;
import org.jooq.postgres.extensions.types.Hstore;

public interface PostgresMailboxDataDefinition {
    public static final PostgresDataDefinition MODULE = PostgresDataDefinition.builder().addTable(new PostgresTable[]{PostgresMailboxTable.TABLE}).addIndex(new PostgresIndex[]{PostgresMailboxTable.MAILBOX_USERNAME_NAMESPACE_INDEX}).build();

    public static interface PostgresMailboxTable {
        public static final Table<Record> TABLE_NAME = DSL.table((String)"mailbox");
        public static final Field<UUID> MAILBOX_ID = DSL.field((String)"mailbox_id", (DataType)SQLDataType.UUID.notNull());
        public static final Field<String> MAILBOX_NAME = DSL.field((String)"mailbox_name", (DataType)SQLDataType.VARCHAR((int)255).notNull());
        public static final Field<Long> MAILBOX_UID_VALIDITY = DSL.field((String)"mailbox_uid_validity", (DataType)SQLDataType.BIGINT.notNull());
        public static final Field<String> USER_NAME = DSL.field((String)"user_name", (DataType)SQLDataType.VARCHAR((int)255));
        public static final Field<String> MAILBOX_NAMESPACE = DSL.field((String)"mailbox_namespace", (DataType)SQLDataType.VARCHAR((int)255).notNull());
        public static final Field<Long> MAILBOX_LAST_UID = DSL.field((String)"mailbox_last_uid", (DataType)SQLDataType.BIGINT);
        public static final Field<Long> MAILBOX_HIGHEST_MODSEQ = DSL.field((String)"mailbox_highest_modseq", (DataType)SQLDataType.BIGINT);
        public static final Field<Hstore> MAILBOX_ACL = DSL.field((String)"mailbox_acl", (DataType)DefaultDataType.getDefaultDataType((String)"hstore").asConvertedDataType((Binding)new HstoreBinding()));
        public static final Field<Long> MAILBOX_ACL_VERSION = DSL.field((String)"mailbox_acl_version", (DataType)SQLDataType.BIGINT.notNull().defaultValue(DSL.field((String)"0", (DataType)SQLDataType.BIGINT)));
        public static final Name MAILBOX_NAME_USER_NAME_NAMESPACE_UNIQUE_CONSTRAINT = DSL.name((String)"mailbox_mailbox_name_user_name_mailbox_namespace_key");
        public static final PostgresTable TABLE = PostgresTable.name((String)TABLE_NAME.getName()).createTableStep((dsl, tableName) -> dsl.createTableIfNotExists(tableName).column(MAILBOX_ID, SQLDataType.UUID).column(MAILBOX_NAME).column(MAILBOX_UID_VALIDITY).column(USER_NAME).column(MAILBOX_NAMESPACE).column(MAILBOX_LAST_UID).column(MAILBOX_HIGHEST_MODSEQ).column(MAILBOX_ACL).column(MAILBOX_ACL_VERSION).constraint((Constraint)DSL.primaryKey((Field[])new Field[]{MAILBOX_ID})).constraint((Constraint)DSL.constraint((Name)MAILBOX_NAME_USER_NAME_NAMESPACE_UNIQUE_CONSTRAINT).unique(new Field[]{MAILBOX_NAME, USER_NAME, MAILBOX_NAMESPACE}))).supportsRowLevelSecurity().addAdditionalAlterQueries(new PostgresTable.AdditionalAlterQuery[]{new PostgresTable.NonRLSOnlyAdditionalAlterQuery("CREATE INDEX mailbox_mailbox_acl_index ON " + TABLE_NAME.getName() + " USING GIN (" + MAILBOX_ACL.getName() + ")")}).build();
        public static final PostgresIndex MAILBOX_USERNAME_NAMESPACE_INDEX = PostgresIndex.name((String)"mailbox_username_namespace_index").createIndexStep((dsl, indexName) -> dsl.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{USER_NAME, MAILBOX_NAMESPACE}));
    }
}

