/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.mail;

import java.util.UUID;
import org.apache.james.backends.postgres.PostgresDataDefinition;
import org.apache.james.backends.postgres.PostgresIndex;
import org.apache.james.backends.postgres.PostgresTable;
import org.jooq.Constraint;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public interface PostgresAttachmentDataDefinition {
    public static final PostgresDataDefinition MODULE = PostgresDataDefinition.builder().addTable(new PostgresTable[]{PostgresAttachmentTable.TABLE}).addIndex(new PostgresIndex[]{PostgresAttachmentTable.MESSAGE_ID_INDEX}).build();

    public static interface PostgresAttachmentTable {
        public static final Table<Record> TABLE_NAME = DSL.table((String)"attachment");
        public static final Field<String> ID = DSL.field((String)"id", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<String> BLOB_ID = DSL.field((String)"blob_id", (DataType)SQLDataType.VARCHAR);
        public static final Field<String> TYPE = DSL.field((String)"type", (DataType)SQLDataType.VARCHAR);
        public static final Field<UUID> MESSAGE_ID = DSL.field((String)"message_id", (DataType)SQLDataType.UUID);
        public static final Field<Long> SIZE = DSL.field((String)"size", (DataType)SQLDataType.BIGINT);
        public static final PostgresTable TABLE = PostgresTable.name((String)TABLE_NAME.getName()).createTableStep((dsl, tableName) -> dsl.createTableIfNotExists(tableName).column(ID).column(BLOB_ID).column(TYPE).column(MESSAGE_ID).column(SIZE).constraint((Constraint)DSL.primaryKey((Field[])new Field[]{ID}))).supportsRowLevelSecurity().build();
        public static final PostgresIndex MESSAGE_ID_INDEX = PostgresIndex.name((String)"attachment_message_id_index").createIndexStep((dsl, indexName) -> dsl.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{MESSAGE_ID}));
    }
}

