/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import org.apache.james.mailbox.model.MailboxId;

public class PostgresMailboxId
implements MailboxId,
Serializable {
    private final UUID id;

    public static PostgresMailboxId generate() {
        return PostgresMailboxId.of(UUID.randomUUID());
    }

    public static PostgresMailboxId of(UUID id) {
        return new PostgresMailboxId(id);
    }

    public static PostgresMailboxId of(String serialized) {
        return new PostgresMailboxId(UUID.fromString(serialized));
    }

    private PostgresMailboxId(UUID id) {
        this.id = id;
    }

    public String serialize() {
        return this.id.toString();
    }

    public UUID asUuid() {
        return this.id;
    }

    public final boolean equals(Object o) {
        if (o instanceof PostgresMailboxId) {
            PostgresMailboxId other = (PostgresMailboxId)o;
            return Objects.equals(this.id, other.id);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).toString();
    }

    public static class Factory
    implements MailboxId.Factory {
        public PostgresMailboxId fromString(String serialized) {
            return PostgresMailboxId.of(serialized);
        }
    }
}

