/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRatio;

public class OccupationRatioDTO {
    private final double size;
    private final double count;
    private final double max;

    public static OccupationRatioDTO from(Quota<QuotaSizeLimit, QuotaSizeUsage> sizeQuota, Quota<QuotaCountLimit, QuotaCountUsage> countQuota) {
        return new OccupationRatioDTO(sizeQuota.getRatio(), countQuota.getRatio(), QuotaRatio.from(sizeQuota, countQuota).max());
    }

    private OccupationRatioDTO(double size, double count, double max) {
        this.size = size;
        this.count = count;
        this.max = max;
    }

    public double getSize() {
        return this.size;
    }

    public double getCount() {
        return this.count;
    }

    public double getMax() {
        return this.max;
    }
}

