/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec.other;

import com.github.f4b6a3.uuid.codec.UuidCodec;
import com.github.f4b6a3.uuid.exception.InvalidUuidException;
import com.github.f4b6a3.uuid.util.UuidUtil;
import com.github.f4b6a3.uuid.util.UuidValidator;
import java.util.UUID;

public class TimeOrderedCodec
implements UuidCodec<UUID> {
    public static final TimeOrderedCodec INSTANCE = new TimeOrderedCodec();

    @Override
    public UUID encode(UUID uuid) {
        UuidValidator.validate(uuid);
        if (!UuidUtil.isTimeBased(uuid)) {
            throw new InvalidUuidException("Not a time-based UUID: " + uuid);
        }
        long timestamp = UuidUtil.getTimestamp(uuid);
        long msb = (timestamp & 0xFFFFFFFFFFFF000L) << 4 | timestamp & 0xFFFL | 0x6000L;
        long lsb = uuid.getLeastSignificantBits();
        return new UUID(msb, lsb);
    }

    @Override
    public UUID decode(UUID uuid) {
        UuidValidator.validate(uuid);
        if (!UuidUtil.isTimeOrdered(uuid)) {
            throw new InvalidUuidException("Not a time-ordered UUID: " + uuid);
        }
        long timestamp = UuidUtil.getTimestamp(uuid);
        long timeHigh = (timestamp & 0xFFF000000000000L) >>> 48;
        long timeMid = (timestamp & 0xFFFF00000000L) >>> 16;
        long timeLow = (timestamp & 0xFFFFFFFFL) << 32;
        long version = 4096L;
        long msb = timeHigh | timeMid | timeLow | version;
        long lsb = uuid.getLeastSignificantBits();
        return new UUID(msb, lsb);
    }
}

