/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.james.mime4j.Charsets;
import org.apache.james.mime4j.dom.BinaryBody;
import org.apache.james.mime4j.dom.SingleBody;
import org.apache.james.mime4j.dom.TextBody;
import org.apache.james.mime4j.io.InputStreams;
import org.apache.james.mime4j.message.BodyFactory;
import org.apache.james.mime4j.util.ByteArrayOutputStreamRecycler;
import org.apache.james.mime4j.util.ContentUtil;

public class BasicBodyFactory
implements BodyFactory {
    public static final BasicBodyFactory INSTANCE = new BasicBodyFactory();
    private final Charset defaultCharset;

    public BasicBodyFactory() {
        this(true);
    }

    public BasicBodyFactory(Charset defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    public BasicBodyFactory(boolean lenient) {
        this(lenient ? Charset.defaultCharset() : null);
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    protected Charset resolveCharset(String mimeCharset) throws UnsupportedEncodingException {
        block5: {
            if (mimeCharset != null) {
                try {
                    return Charset.forName(mimeCharset);
                }
                catch (UnsupportedCharsetException ex) {
                    if (this.defaultCharset == null) {
                        throw new UnsupportedEncodingException(mimeCharset);
                    }
                }
                catch (IllegalCharsetNameException ex) {
                    if (this.defaultCharset != null) break block5;
                    throw new UnsupportedEncodingException(mimeCharset);
                }
            }
        }
        return this.defaultCharset;
    }

    public TextBody textBody(String text, String mimeCharset) throws UnsupportedEncodingException {
        if (text == null) {
            throw new IllegalArgumentException("Text may not be null");
        }
        return new StringBody1(text, this.resolveCharset(mimeCharset));
    }

    public TextBody textBody(byte[] content, Charset charset) {
        if (content == null) {
            throw new IllegalArgumentException("Content may not be null");
        }
        return new StringBody2(content, charset);
    }

    @Override
    public TextBody textBody(InputStream content, String mimeCharset) throws IOException {
        if (content == null) {
            throw new IllegalArgumentException("Input stream may not be null");
        }
        return new StringBody3(ContentUtil.bufferEfficient((InputStream)content), this.resolveCharset(mimeCharset));
    }

    public TextBody textBody(String text, Charset charset) {
        if (text == null) {
            throw new IllegalArgumentException("Text may not be null");
        }
        return new StringBody1(text, charset);
    }

    public TextBody textBody(String text) {
        return this.textBody(text, Charsets.DEFAULT_CHARSET);
    }

    public BinaryBody binaryBody(String content, Charset charset) {
        if (content == null) {
            throw new IllegalArgumentException("Content may not be null");
        }
        return new BinaryBody2(content, charset);
    }

    @Override
    public BinaryBody binaryBody(InputStream is) throws IOException {
        return new BinaryBody3(ContentUtil.bufferEfficient((InputStream)is));
    }

    public BinaryBody binaryBody(byte[] buf) {
        return new BinaryBody1(buf);
    }

    static class StringBody1
    extends TextBody {
        private final String content;
        private final Charset charset;

        StringBody1(String content, Charset charset) {
            this.content = content;
            this.charset = charset;
        }

        @Override
        public String getMimeCharset() {
            return this.charset != null ? this.charset.name() : null;
        }

        @Override
        public Charset getCharset() {
            return this.charset;
        }

        @Override
        public Reader getReader() throws IOException {
            return new StringReader(this.content);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return InputStreams.create((CharSequence)this.content, (Charset)(this.charset != null ? this.charset : Charsets.DEFAULT_CHARSET));
        }

        @Override
        public void dispose() {
        }

        @Override
        public SingleBody copy() {
            return new StringBody1(this.content, this.charset);
        }
    }

    static class StringBody2
    extends TextBody {
        private final byte[] content;
        private final Charset charset;

        StringBody2(byte[] content, Charset charset) {
            this.content = content;
            this.charset = charset;
        }

        @Override
        public String getMimeCharset() {
            return this.charset != null ? this.charset.name() : null;
        }

        @Override
        public Charset getCharset() {
            return this.charset;
        }

        @Override
        public Reader getReader() throws IOException {
            return new InputStreamReader(InputStreams.create((byte[])this.content), this.charset);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return InputStreams.create((byte[])this.content);
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            out.write(this.content);
        }

        @Override
        public long size() {
            return this.content.length;
        }

        @Override
        public void dispose() {
        }

        @Override
        public SingleBody copy() {
            return new StringBody2(this.content, this.charset);
        }
    }

    static class StringBody3
    extends TextBody {
        private final ByteArrayOutputStreamRecycler.Wrapper content;
        private final Charset charset;

        StringBody3(ByteArrayOutputStreamRecycler.Wrapper content, Charset charset) {
            this.content = content;
            this.charset = charset;
        }

        @Override
        public String getMimeCharset() {
            return this.charset != null ? this.charset.name() : null;
        }

        @Override
        public Charset getCharset() {
            return this.charset;
        }

        @Override
        public Reader getReader() throws IOException {
            return new InputStreamReader(this.content.getValue().toInputStream(), this.charset);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.content.getValue().toInputStream();
        }

        @Override
        public long size() {
            return this.content.getValue().size();
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            this.content.getValue().writeTo(out);
        }

        @Override
        public void dispose() {
            this.content.release();
        }

        @Override
        public SingleBody copy() {
            return new StringBody3(this.content, this.charset);
        }
    }

    static class BinaryBody2
    extends BinaryBody {
        private final String content;
        private final Charset charset;

        BinaryBody2(String content, Charset charset) {
            this.content = content;
            this.charset = charset;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return InputStreams.create((CharSequence)this.content, (Charset)(this.charset != null ? this.charset : Charsets.DEFAULT_CHARSET));
        }

        @Override
        public void dispose() {
        }

        @Override
        public SingleBody copy() {
            return new BinaryBody2(this.content, this.charset);
        }
    }

    static class BinaryBody3
    extends BinaryBody {
        private final ByteArrayOutputStreamRecycler.Wrapper content;

        BinaryBody3(ByteArrayOutputStreamRecycler.Wrapper content) {
            this.content = content;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.content.getValue().toInputStream();
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            this.content.getValue().writeTo(out);
        }

        @Override
        public long size() {
            return this.content.getValue().size();
        }

        @Override
        public void dispose() {
            this.content.release();
        }

        @Override
        public SingleBody copy() {
            return new BinaryBody3(this.content);
        }
    }

    static class BinaryBody1
    extends BinaryBody {
        private final byte[] content;

        BinaryBody1(byte[] content) {
            this.content = content;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return InputStreams.create((byte[])this.content);
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            out.write(this.content);
        }

        @Override
        public long size() {
            return this.content.length;
        }

        @Override
        public void dispose() {
        }

        @Override
        public SingleBody copy() {
            return new BinaryBody1(this.content);
        }
    }
}

