/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.List;
import java.util.function.Function;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.GetQuotaRootRequest;
import org.apache.james.imap.message.response.QuotaResponse;
import org.apache.james.imap.message.response.QuotaRootResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class GetQuotaRootProcessor
extends AbstractMailboxProcessor<GetQuotaRootRequest>
implements CapabilityImplementingProcessor {
    private static final List<Capability> CAPABILITIES = ImmutableList.of((Object)ImapConstants.SUPPORTS_QUOTA, (Object)ImapConstants.SUPPORTS_QUOTA_RES_MESSAGE, (Object)ImapConstants.SUPPORTS_QUOTA_RES_STORAGE);
    private final QuotaRootResolver quotaRootResolver;
    private final QuotaManager quotaManager;
    private final PathConverter.Factory pathConverterFactory;

    @Inject
    public GetQuotaRootProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, QuotaRootResolver quotaRootResolver, QuotaManager quotaManager, MetricFactory metricFactory, PathConverter.Factory pathConverterFactory) {
        super(GetQuotaRootRequest.class, mailboxManager, factory, metricFactory);
        this.quotaRootResolver = quotaRootResolver;
        this.quotaManager = quotaManager;
        this.pathConverterFactory = pathConverterFactory;
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return CAPABILITIES;
    }

    @Override
    protected Mono<Void> processRequestReactive(GetQuotaRootRequest request, ImapSession session, ImapProcessor.Responder responder) {
        MailboxSession mailboxSession = session.getMailboxSession();
        MailboxManager mailboxManager = this.getMailboxManager();
        MailboxPath mailboxPath = this.pathConverterFactory.forSession(session).buildFullPath(request.getMailboxName());
        return Mono.from((Publisher)mailboxManager.getMailboxReactive(mailboxPath, mailboxSession)).flatMap((Function)Throwing.function(messageManager -> {
            if (mailboxManager.hasRight(messageManager.getMailboxEntity(), MailboxACL.Right.Read, mailboxSession)) {
                return this.respondQuotas(request, responder, mailboxPath);
            }
            Object[] params = new Object[]{MailboxACL.Right.Read.toString(), request.getCommand().getName(), request.getMailboxName()};
            HumanReadableText humanReadableText = new HumanReadableText("org.apache.james.imap.UNSUFFICIENT_RIGHTS", "You need the {0} right to perform command {1} on mailbox {2}.", params);
            this.no(request, responder, humanReadableText);
            return Mono.empty();
        }));
    }

    private Mono<Void> respondQuotas(GetQuotaRootRequest request, ImapProcessor.Responder responder, MailboxPath mailboxPath) {
        return Mono.from((Publisher)this.quotaRootResolver.getQuotaRootReactive(mailboxPath)).flatMap(quotaRoot -> Mono.from((Publisher)this.quotaManager.getQuotasReactive(quotaRoot)).doOnNext(quotas -> {
            Quota messageQuota = quotas.getMessageQuota();
            Quota storageQuota = quotas.getStorageQuota();
            responder.respond(new QuotaRootResponse(request.getMailboxName(), quotaRoot.getValue()));
            if (((QuotaCountLimit)messageQuota.getLimit()).isLimited()) {
                responder.respond(new QuotaResponse("MESSAGE", quotaRoot.getValue(), messageQuota));
            }
            if (((QuotaSizeLimit)storageQuota.getLimit()).isLimited()) {
                responder.respond(new QuotaResponse("STORAGE", quotaRoot.getValue(), storageQuota));
            }
            this.okComplete(request, responder);
        })).onErrorResume(MailboxException.class, e -> {
            this.taggedBad(request, responder, HumanReadableText.FAILURE_NO_SUCH_MAILBOX);
            return Mono.empty();
        }).then();
    }

    @Override
    protected MDCBuilder mdc(GetQuotaRootRequest request) {
        return MDCBuilder.create().addToContext("action", "GET_QUOTA_ROOT").addToContext("mailbox", request.getMailboxName());
    }
}

