/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import com.github.fge.lambdas.Throwing;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseEncoder;
import org.apache.james.imap.message.MailboxName;
import org.apache.james.imap.message.response.ListRightsResponse;
import org.apache.james.mailbox.model.MailboxACL;

public class ListRightsResponseEncoder
implements ImapResponseEncoder<ListRightsResponse> {
    @Override
    public Class<ListRightsResponse> acceptableMessages() {
        return ListRightsResponse.class;
    }

    @Override
    public void encode(ListRightsResponse listRightsResponse, ImapResponseComposer composer) throws IOException {
        composer.untagged();
        composer.commandName(ImapConstants.LISTRIGHTS_COMMAND);
        Optional.ofNullable(listRightsResponse.getMailboxName()).ifPresent((Consumer<MailboxName>)Throwing.consumer(value -> composer.mailbox(value.asString())));
        MailboxACL.EntryKey entryKey = listRightsResponse.getEntryKey();
        composer.quote(entryKey.toString());
        List<MailboxACL.Rfc4314Rights> rights = listRightsResponse.getRights();
        for (MailboxACL.Rfc4314Rights entry : rights) {
            composer.quote(entry.serialize());
        }
        composer.end();
    }
}

