/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.eventsourcing.eventstore.cassandra;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.Event$;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.eventsourcing.eventstore.EventStoreFailedException;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.eventsourcing.eventstore.cassandra.EventStoreDao;
import org.reactivestreams.Publisher;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scala.publisher.package$;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005A4Aa\u0002\u0005\u0001+!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005C\u0003&\u0001\u0011\u0005a\u0005C\u00033\u0001\u0011\u00053\u0007C\u0003U\u0001\u0011%Q\u000bC\u0003c\u0001\u0011\u00053\rC\u0003n\u0001\u0011\u0005cNA\nDCN\u001c\u0018M\u001c3sC\u00163XM\u001c;Ti>\u0014XM\u0003\u0002\n\u0015\u0005I1-Y:tC:$'/\u0019\u0006\u0003\u00171\t!\"\u001a<f]R\u001cHo\u001c:f\u0015\tia\"A\u0007fm\u0016tGo]8ve\u000eLgn\u001a\u0006\u0003\u001fA\tQA[1nKNT!!\u0005\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0012aA8sO\u000e\u00011c\u0001\u0001\u00179A\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t1\u0011I\\=SK\u001a\u0004\"!\b\u0010\u000e\u0003)I!a\b\u0006\u0003\u0015\u00153XM\u001c;Ti>\u0014X-A\u0007fm\u0016tGo\u0015;pe\u0016$\u0015m\u001c\t\u0003E\rj\u0011\u0001C\u0005\u0003I!\u0011Q\"\u0012<f]R\u001cFo\u001c:f\t\u0006|\u0017A\u0002\u001fj]&$h\b\u0006\u0002(QA\u0011!\u0005\u0001\u0005\u0006A\t\u0001\r!\t\u0015\u0003\u0005)\u0002\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\r%t'.Z2u\u0015\u0005y\u0013a\u00026bW\u0006\u0014H/Y\u0005\u0003c1\u0012a!\u00138kK\u000e$\u0018!C1qa\u0016tG-\u00117m)\t!$\tE\u00026qij\u0011A\u000e\u0006\u0003oI\tqB]3bGRLg/Z:ue\u0016\fWn]\u0005\u0003sY\u0012\u0011\u0002U;cY&\u001c\b.\u001a:\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014\u0001\u00027b]\u001eT\u0011aP\u0001\u0005U\u00064\u0018-\u0003\u0002By\t!ak\\5e\u0011\u0015\u00195\u00011\u0001E\u0003\u0019)g/\u001a8ugB\u0019Q)\u0014)\u000f\u0005\u0019[eBA$K\u001b\u0005A%BA%\u0015\u0003\u0019a$o\\8u}%\t\u0011$\u0003\u0002M1\u00059\u0001/Y2lC\u001e,\u0017B\u0001(P\u0005!IE/\u001a:bE2,'B\u0001'\u0019!\t\t&+D\u0001\r\u0013\t\u0019FBA\u0003Fm\u0016tG/A\u0006e_\u0006\u0003\b/\u001a8e\u00032dGC\u0001,b!\r9vLO\u0007\u00021*\u0011\u0011LW\u0001\naV\u0014G.[:iKJT!!G.\u000b\u0005qk\u0016\u0001B2pe\u0016T\u0011AX\u0001\be\u0016\f7\r^8s\u0013\t\u0001\u0007LA\u0003T\u001b>tw\u000eC\u0003D\t\u0001\u0007A)\u0001\u000bhKR,e/\u001a8ug>3\u0017iZ4sK\u001e\fG/\u001a\u000b\u0003I\"\u00042aV0f!\tib-\u0003\u0002h\u0015\t9\u0001*[:u_JL\b\"B5\u0006\u0001\u0004Q\u0017aC1hOJ,w-\u0019;f\u0013\u0012\u0004\"!U6\n\u00051d!aC!hOJ,w-\u0019;f\u0013\u0012\faA]3n_Z,GC\u0001\u001bp\u0011\u0015Ig\u00011\u0001k\u0001")
public class CassandraEventStore
implements EventStore {
    private final EventStoreDao eventStoreDao;

    public Publisher<Void> append(Event event) {
        return EventStore.append$((EventStore)this, (Event)event);
    }

    public Publisher<Void> appendAll(Seq<Event> events) {
        return EventStore.appendAll$((EventStore)this, events);
    }

    public Publisher<Void> appendAll(Event ... events) {
        return EventStore.appendAll$((EventStore)this, (Event[])events);
    }

    public Publisher<Void> appendAll(Iterable<Event> events) {
        if (events.nonEmpty()) {
            return this.doAppendAll(events);
        }
        return SMono$.MODULE$.empty();
    }

    private SMono<Void> doAppendAll(Iterable<Event> events) {
        Preconditions.checkArgument((boolean)Event$.MODULE$.belongsToSameAggregate(events));
        Option snapshotId = ((IterableOps)((IterableOps)events.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isASnapshot()))).map((Function1 & Serializable)x$2 -> x$2.eventId())).headOption();
        return this.eventStoreDao.appendAll(events, (Option<EventId>)snapshotId).filter((Function1 & Serializable)success -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)success))).single().onErrorMap((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof NoSuchElementException) {
                    return (B1)new EventStoreFailedException("Concurrent update to the EventStore detected");
                }
                return (B1)A1;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                if (throwable instanceof NoSuchElementException) {
                    return true;
                }
                return true;
            }
        }).then(SMono$.MODULE$.empty());
    }

    public SMono<History> getEventsOfAggregate(AggregateId aggregateId) {
        return this.eventStoreDao.getSnapshot(aggregateId).flatMap((Function1 & Serializable)snapshotId -> $this.eventStoreDao.getEventsOfAggregate(aggregateId, (EventId)snapshotId)).switchIfEmpty(this.eventStoreDao.getEventsOfAggregate(aggregateId));
    }

    public Publisher<Void> remove(AggregateId aggregateId) {
        return package$.MODULE$.publisherUnit2PublisherVoid(this.eventStoreDao.delete(aggregateId));
    }

    @Inject
    public CassandraEventStore(EventStoreDao eventStoreDao) {
        this.eventStoreDao = eventStoreDao;
        EventStore.$init$((EventStore)this);
    }
}

