/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.data;

import com.datastax.oss.driver.api.core.data.AccessibleByIndex;
import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.core.data.CqlVector;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveBooleanCodec;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveByteCodec;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveDoubleCodec;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveFloatCodec;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveIntCodec;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveLongCodec;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveShortCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.metadata.token.ByteOrderedToken;
import com.datastax.oss.driver.internal.core.metadata.token.Murmur3Token;
import com.datastax.oss.driver.internal.core.metadata.token.RandomToken;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public interface GettableByIndex
extends AccessibleByIndex {
    @Nullable
    public ByteBuffer getBytesUnsafe(int var1);

    default public boolean isNull(int i) {
        return this.getBytesUnsafe(i) == null;
    }

    @Nullable
    default public <ValueT> ValueT get(int i, TypeCodec<ValueT> codec) {
        return codec.decode(this.getBytesUnsafe(i), this.protocolVersion());
    }

    @Nullable
    default public <ValueT> ValueT get(int i, GenericType<ValueT> targetType) {
        DataType cqlType = this.getType(i);
        TypeCodec<GenericType<ValueT>> codec = this.codecRegistry().codecFor(cqlType, targetType);
        return (ValueT)this.get(i, codec);
    }

    @Nullable
    default public <ValueT> ValueT get(int i, Class<ValueT> targetClass) {
        DataType cqlType = this.getType(i);
        TypeCodec<Class<ValueT>> codec = this.codecRegistry().codecFor(cqlType, targetClass);
        return (ValueT)this.get(i, codec);
    }

    @Nullable
    default public Object getObject(int i) {
        DataType cqlType = this.getType(i);
        TypeCodec<DataType> codec = this.codecRegistry().codecFor(cqlType);
        return codec.decode(this.getBytesUnsafe(i), this.protocolVersion());
    }

    default public boolean getBoolean(int i) {
        DataType cqlType = this.getType(i);
        TypeCodec<Class<Boolean>> codec = this.codecRegistry().codecFor(cqlType, Boolean.class);
        if (codec instanceof PrimitiveBooleanCodec) {
            return ((PrimitiveBooleanCodec)codec).decodePrimitive(this.getBytesUnsafe(i), this.protocolVersion());
        }
        Boolean value = (Boolean)((Object)this.get(i, codec));
        return value == null ? false : value;
    }

    @Deprecated
    default public boolean getBool(int i) {
        return this.getBoolean(i);
    }

    default public byte getByte(int i) {
        DataType cqlType = this.getType(i);
        TypeCodec<Class<Byte>> codec = this.codecRegistry().codecFor(cqlType, Byte.class);
        if (codec instanceof PrimitiveByteCodec) {
            return ((PrimitiveByteCodec)codec).decodePrimitive(this.getBytesUnsafe(i), this.protocolVersion());
        }
        Byte value = (Byte)((Object)this.get(i, codec));
        return value == null ? (byte)0 : value;
    }

    default public double getDouble(int i) {
        DataType cqlType = this.getType(i);
        TypeCodec<Class<Double>> codec = this.codecRegistry().codecFor(cqlType, Double.class);
        if (codec instanceof PrimitiveDoubleCodec) {
            return ((PrimitiveDoubleCodec)codec).decodePrimitive(this.getBytesUnsafe(i), this.protocolVersion());
        }
        Double value = (Double)((Object)this.get(i, codec));
        return value == null ? 0.0 : value;
    }

    default public float getFloat(int i) {
        DataType cqlType = this.getType(i);
        TypeCodec<Class<Float>> codec = this.codecRegistry().codecFor(cqlType, Float.class);
        if (codec instanceof PrimitiveFloatCodec) {
            return ((PrimitiveFloatCodec)codec).decodePrimitive(this.getBytesUnsafe(i), this.protocolVersion());
        }
        Float value = (Float)((Object)this.get(i, codec));
        return value == null ? 0.0f : value.floatValue();
    }

    default public int getInt(int i) {
        DataType cqlType = this.getType(i);
        TypeCodec<Class<Integer>> codec = this.codecRegistry().codecFor(cqlType, Integer.class);
        if (codec instanceof PrimitiveIntCodec) {
            return ((PrimitiveIntCodec)codec).decodePrimitive(this.getBytesUnsafe(i), this.protocolVersion());
        }
        Integer value = (Integer)((Object)this.get(i, codec));
        return value == null ? 0 : value;
    }

    default public long getLong(int i) {
        DataType cqlType = this.getType(i);
        TypeCodec<Class<Long>> codec = this.codecRegistry().codecFor(cqlType, Long.class);
        if (codec instanceof PrimitiveLongCodec) {
            return ((PrimitiveLongCodec)codec).decodePrimitive(this.getBytesUnsafe(i), this.protocolVersion());
        }
        Long value = (Long)((Object)this.get(i, codec));
        return value == null ? 0L : value;
    }

    default public short getShort(int i) {
        DataType cqlType = this.getType(i);
        TypeCodec<Class<Short>> codec = this.codecRegistry().codecFor(cqlType, Short.class);
        if (codec instanceof PrimitiveShortCodec) {
            return ((PrimitiveShortCodec)codec).decodePrimitive(this.getBytesUnsafe(i), this.protocolVersion());
        }
        Short value = (Short)((Object)this.get(i, codec));
        return value == null ? (short)0 : value;
    }

    @Nullable
    default public Instant getInstant(int i) {
        return this.get(i, Instant.class);
    }

    @Nullable
    default public LocalDate getLocalDate(int i) {
        return this.get(i, LocalDate.class);
    }

    @Nullable
    default public LocalTime getLocalTime(int i) {
        return this.get(i, LocalTime.class);
    }

    @Nullable
    default public ByteBuffer getByteBuffer(int i) {
        return this.get(i, ByteBuffer.class);
    }

    @Nullable
    default public String getString(int i) {
        return this.get(i, String.class);
    }

    @Nullable
    default public BigInteger getBigInteger(int i) {
        return this.get(i, BigInteger.class);
    }

    @Nullable
    default public BigDecimal getBigDecimal(int i) {
        return this.get(i, BigDecimal.class);
    }

    @Nullable
    default public UUID getUuid(int i) {
        return this.get(i, UUID.class);
    }

    @Nullable
    default public InetAddress getInetAddress(int i) {
        return this.get(i, InetAddress.class);
    }

    @Nullable
    default public CqlDuration getCqlDuration(int i) {
        return this.get(i, CqlDuration.class);
    }

    @Nullable
    default public <ElementT> CqlVector<ElementT> getVector(int i, @NonNull Class<ElementT> elementsClass) {
        return this.get(i, GenericType.vectorOf(elementsClass));
    }

    @Nullable
    default public Token getToken(int i) {
        DataType type = this.getType(i);
        if (type.equals(DataTypes.BIGINT)) {
            return this.isNull(i) ? null : new Murmur3Token(this.getLong(i));
        }
        if (type.equals(DataTypes.BLOB)) {
            return this.isNull(i) ? null : new ByteOrderedToken(this.getByteBuffer(i));
        }
        if (type.equals(DataTypes.VARINT)) {
            return this.isNull(i) ? null : new RandomToken(this.getBigInteger(i));
        }
        throw new IllegalArgumentException("Can't convert CQL type " + type + " into a token");
    }

    @Nullable
    default public <ElementT> List<ElementT> getList(int i, @NonNull Class<ElementT> elementsClass) {
        return this.get(i, GenericType.listOf(elementsClass));
    }

    @Nullable
    default public <ElementT> Set<ElementT> getSet(int i, @NonNull Class<ElementT> elementsClass) {
        return this.get(i, GenericType.setOf(elementsClass));
    }

    @Nullable
    default public <KeyT, ValueT> Map<KeyT, ValueT> getMap(int i, @NonNull Class<KeyT> keyClass, @NonNull Class<ValueT> valueClass) {
        return this.get(i, GenericType.mapOf(keyClass, valueClass));
    }

    @Nullable
    default public UdtValue getUdtValue(int i) {
        return this.get(i, UdtValue.class);
    }

    @Nullable
    default public TupleValue getTupleValue(int i) {
        return this.get(i, TupleValue.class);
    }
}

