/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph.reactive;

import com.datastax.dse.driver.api.core.graph.AsyncGraphResultSet;
import com.datastax.dse.driver.api.core.graph.reactive.ReactiveGraphNode;
import com.datastax.dse.driver.api.core.graph.reactive.ReactiveGraphResultSet;
import com.datastax.dse.driver.internal.core.cql.reactive.EmptySubscription;
import com.datastax.dse.driver.internal.core.cql.reactive.SimpleUnicastProcessor;
import com.datastax.dse.driver.internal.core.graph.reactive.ReactiveGraphResultSetSubscription;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.ThreadSafe;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@ThreadSafe
public class DefaultReactiveGraphResultSet
implements ReactiveGraphResultSet {
    private final Callable<CompletionStage<AsyncGraphResultSet>> firstPage;
    private final AtomicBoolean alreadySubscribed = new AtomicBoolean(false);
    private final SimpleUnicastProcessor<ExecutionInfo> executionInfosPublisher = new SimpleUnicastProcessor();

    public DefaultReactiveGraphResultSet(Callable<CompletionStage<AsyncGraphResultSet>> firstPage) {
        this.firstPage = firstPage;
    }

    public void subscribe(@NonNull Subscriber<? super ReactiveGraphNode> subscriber) {
        Objects.requireNonNull(subscriber, "Subscriber cannot be null");
        if (this.alreadySubscribed.compareAndSet(false, true)) {
            ReactiveGraphResultSetSubscription subscription = new ReactiveGraphResultSetSubscription(subscriber, (Subscriber<ExecutionInfo>)this.executionInfosPublisher);
            try {
                subscriber.onSubscribe((Subscription)subscription);
                subscription.start(this.firstPage);
            }
            catch (Throwable t) {
                subscription.doOnError(new IllegalStateException(subscriber + " violated the Reactive Streams rule 2.13 by throwing an exception from onSubscribe.", t));
            }
        } else {
            subscriber.onSubscribe((Subscription)EmptySubscription.INSTANCE);
            subscriber.onError((Throwable)new IllegalStateException("This publisher does not support multiple subscriptions"));
        }
    }

    @Override
    @NonNull
    public Publisher<? extends ExecutionInfo> getExecutionInfos() {
        return this.executionInfosPublisher;
    }
}

