/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.netty;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.core.ConnectionDescription;
import org.apache.james.core.ConnectionDescriptionSupplier;
import org.apache.james.core.Disconnector;
import org.apache.james.core.Username;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.lib.handler.ProtocolHandlerLoader;
import org.apache.james.protocols.lib.netty.AbstractConfigurableAsyncServer;
import org.apache.james.protocols.lib.netty.AbstractServerFactory;
import org.apache.james.smtpserver.netty.SMTPServer;
import org.apache.james.smtpserver.netty.SmtpMetricsImpl;

public class SMTPServerFactory
extends AbstractServerFactory
implements Disconnector,
ConnectionDescriptionSupplier {
    protected final DNSService dns;
    protected final ProtocolHandlerLoader loader;
    protected final FileSystem fileSystem;
    protected final SmtpMetricsImpl smtpMetrics;

    @Inject
    public SMTPServerFactory(DNSService dns, ProtocolHandlerLoader loader, FileSystem fileSystem, MetricFactory metricFactory) {
        this.dns = dns;
        this.loader = loader;
        this.fileSystem = fileSystem;
        this.smtpMetrics = new SmtpMetricsImpl(metricFactory);
    }

    protected SMTPServer createServer() {
        return new SMTPServer(this.smtpMetrics);
    }

    protected List<AbstractConfigurableAsyncServer> createServers(HierarchicalConfiguration<ImmutableNode> config) throws Exception {
        ArrayList<AbstractConfigurableAsyncServer> servers = new ArrayList<AbstractConfigurableAsyncServer>();
        List configs = config.configurationsAt("smtpserver");
        for (HierarchicalConfiguration serverConfig : configs) {
            SMTPServer server = this.createServer();
            server.setDnsService(this.dns);
            server.setProtocolHandlerLoader(this.loader);
            server.setFileSystem(this.fileSystem);
            server.configure(serverConfig);
            servers.add((AbstractConfigurableAsyncServer)server);
        }
        return servers;
    }

    public void disconnect(Predicate<Username> username) {
        this.getServers().stream().map(server -> (SMTPServer)server).forEach(smtpServer -> smtpServer.disconnect(username));
    }

    public Stream<ConnectionDescription> describeConnections() {
        return this.getServers().stream().map(server -> (SMTPServer)server).flatMap(SMTPServer::describeConnections);
    }
}

