/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mailet;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.BodyPart;
import jakarta.mail.Header;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class TextCalendarBodyToAttachment
extends GenericMailet {
    private static final String TEXT_CALENDAR_TYPE = "text/calendar";
    private static final String CONTENT_HEADER_PREFIX = "Content-";

    public String getMailetInfo() {
        return "Moves body part of content type text/calendar to attachment";
    }

    public void service(Mail mail) throws MessagingException {
        MimeMessage mimeMessage = mail.getMessage();
        if (mimeMessage.isMimeType(TEXT_CALENDAR_TYPE)) {
            this.processTextBodyAsAttachment(mimeMessage);
        }
    }

    @VisibleForTesting
    void processTextBodyAsAttachment(MimeMessage mimeMessage) throws MessagingException {
        List<Header> contentHeaders = this.getContentHeadersFromMimeMessage(mimeMessage);
        this.removeAllContentHeaderFromMimeMessage(mimeMessage, contentHeaders);
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)this.createMimeBodyPartWithContentHeadersFromMimeMessage(mimeMessage, contentHeaders));
        mimeMessage.setContent((Multipart)multipart);
        mimeMessage.saveChanges();
    }

    private List<Header> getContentHeadersFromMimeMessage(MimeMessage mimeMessage) throws MessagingException {
        return (List)Collections.list(mimeMessage.getAllHeaders()).stream().filter(header -> header.getName().startsWith(CONTENT_HEADER_PREFIX)).collect(ImmutableList.toImmutableList());
    }

    private MimeBodyPart createMimeBodyPartWithContentHeadersFromMimeMessage(MimeMessage mimeMessage, List<Header> contentHeaders) throws MessagingException {
        MimeBodyPart fileBody = new MimeBodyPart();
        try {
            fileBody.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(mimeMessage.getRawInputStream(), mimeMessage.getContentType())));
        }
        catch (IOException e) {
            throw new MessagingException("Error converting message to mime multipart", (Exception)e);
        }
        for (Header header : contentHeaders) {
            fileBody.setHeader(header.getName(), header.getValue());
        }
        fileBody.setDisposition("attachment");
        return fileBody;
    }

    private void removeAllContentHeaderFromMimeMessage(MimeMessage mimeMessage, List<Header> contentHeaders) throws MessagingException {
        for (Header header : contentHeaders) {
            mimeMessage.removeHeader(header.getName());
        }
    }
}

