/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.event;

import jakarta.inject.Inject;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.james.events.Event;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.RightManager;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PropagateLookupRightListener
implements EventListener.ReactiveGroupEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropagateLookupRightListener.class);
    private static final Group GROUP = new PropagateLookupRightListenerGroup();
    private final RightManager rightManager;
    private final MailboxManager mailboxManager;

    @Inject
    public PropagateLookupRightListener(RightManager rightManager, MailboxManager mailboxManager) {
        this.rightManager = rightManager;
        this.mailboxManager = mailboxManager;
    }

    public Group getDefaultGroup() {
        return GROUP;
    }

    public boolean isHandling(Event event) {
        return event instanceof MailboxEvents.MailboxACLUpdated || event instanceof MailboxEvents.MailboxRenamed;
    }

    public Publisher<Void> reactiveEvent(Event event) {
        if (event instanceof MailboxEvents.MailboxACLUpdated) {
            return this.updateLookupRightOnParent((MailboxEvents.MailboxACLUpdated)event);
        }
        if (event instanceof MailboxEvents.MailboxRenamed) {
            return this.updateLookupRightOnParent((MailboxEvents.MailboxRenamed)event);
        }
        return Mono.empty();
    }

    private Mono<Void> updateLookupRightOnParent(MailboxEvents.MailboxACLUpdated aclUpdateEvent) {
        MailboxSession mailboxSession = this.createMailboxSession((Event)aclUpdateEvent);
        return Mono.from((Publisher)this.mailboxManager.getMailboxReactive(aclUpdateEvent.getMailboxId(), mailboxSession)).map(MessageManager::getMailboxPath).flatMapIterable(mailboxPath -> mailboxPath.getParents(mailboxSession.getPathDelimiter())).flatMap(parentPath -> this.updateLookupRight(mailboxSession, (MailboxPath)parentPath, aclUpdateEvent.getAclDiff())).then();
    }

    private Mono<Void> updateLookupRightOnParent(MailboxEvents.MailboxRenamed mailboxRenamed) {
        MailboxSession mailboxSession = this.createMailboxSession((Event)mailboxRenamed);
        return Mono.from((Publisher)this.rightManager.listRightsReactive(mailboxRenamed.getNewPath(), mailboxSession)).onErrorResume(MailboxNotFoundException.class, e -> {
            LOGGER.info("Mailbox {} not found, skip lookup right update", (Object)mailboxRenamed.getNewPath());
            return Mono.empty();
        }).flatMapIterable(acl -> acl.getEntries().entrySet()).map(mapEntry -> new MailboxACL.Entry((MailboxACL.EntryKey)mapEntry.getKey(), (MailboxACL.Rfc4314Rights)mapEntry.getValue())).filter(this.updateLookupRightPredicate()).collectList().flatMap(entries -> Flux.fromIterable((Iterable)mailboxRenamed.getNewPath().getParents(mailboxSession.getPathDelimiter())).flatMap(parentPath -> this.updateLookupRight(mailboxSession, (MailboxPath)parentPath, (List<MailboxACL.Entry>)entries)).then());
    }

    private Mono<Void> updateLookupRight(MailboxSession session, MailboxPath mailboxPath, ACLDiff aclDiff) {
        return this.updateLookupRight(session, mailboxPath, Stream.concat(aclDiff.addedEntries(), aclDiff.changedEntries()));
    }

    private Mono<Void> updateLookupRight(MailboxSession session, MailboxPath mailboxPath, Stream<MailboxACL.Entry> entryStream) {
        return Flux.fromStream(entryStream).filter(this.updateLookupRightPredicate()).flatMap(entry -> this.applyLookupRight(session, mailboxPath, (MailboxACL.EntryKey)entry.getKey())).then();
    }

    private Predicate<MailboxACL.Entry> updateLookupRightPredicate() {
        return entry -> !((MailboxACL.EntryKey)entry.getKey()).isNegative() && ((MailboxACL.Rfc4314Rights)entry.getValue()).contains(MailboxACL.Right.Lookup);
    }

    private Mono<Void> updateLookupRight(MailboxSession session, MailboxPath mailboxPath, List<MailboxACL.Entry> entries) {
        return Flux.fromIterable(entries).flatMap(entry -> this.applyLookupRight(session, mailboxPath, (MailboxACL.EntryKey)entry.getKey())).then();
    }

    private MailboxSession createMailboxSession(Event event) {
        return this.mailboxManager.createSystemSession(event.getUsername());
    }

    private Mono<Void> applyLookupRight(MailboxSession session, MailboxPath mailboxPath, MailboxACL.EntryKey entryKey) {
        if (entryKey.equals((Object)MailboxACL.OWNER_KEY)) {
            return Mono.empty();
        }
        return Mono.from((Publisher)this.rightManager.listRightsReactive(mailboxPath, session)).filter(PropagateLookupRightListener.notContainLookupRightPredicate(entryKey)).flatMap(acl -> Mono.fromCallable(() -> MailboxACL.command().rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup}).key(entryKey).asAddition())).flatMap(aclCommand -> Mono.from((Publisher)this.rightManager.applyRightsCommandReactive(mailboxPath, aclCommand, session))).onErrorResume(MailboxNotFoundException.class, e -> {
            LOGGER.info("Mailbox {} not found, skip lookup right update", (Object)mailboxPath);
            return Mono.empty();
        });
    }

    private static Predicate<MailboxACL> notContainLookupRightPredicate(MailboxACL.EntryKey entryKey) {
        return acl -> !acl.getEntries().containsKey(entryKey) || !((MailboxACL.Rfc4314Rights)acl.getEntries().get(entryKey)).contains(MailboxACL.Right.Lookup);
    }

    public static class PropagateLookupRightListenerGroup
    extends Group {
    }
}

