/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.blob;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Collection;
import org.apache.james.blob.api.BucketName;
import org.apache.james.json.DTOModule;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.james.vault.blob.BlobStoreVaultGarbageCollectionTask;

public class BlobStoreVaultGarbageCollectionTaskAdditionalInformationDTO
implements AdditionalInformationDTO {
    public static final AdditionalInformationDTOModule<BlobStoreVaultGarbageCollectionTask.AdditionalInformation, BlobStoreVaultGarbageCollectionTaskAdditionalInformationDTO> MODULE = (AdditionalInformationDTOModule)DTOModule.forDomainObject(BlobStoreVaultGarbageCollectionTask.AdditionalInformation.class).convertToDTO(BlobStoreVaultGarbageCollectionTaskAdditionalInformationDTO.class).toDomainObjectConverter(BlobStoreVaultGarbageCollectionTaskAdditionalInformationDTO::toDomainObject).toDTOConverter(BlobStoreVaultGarbageCollectionTaskAdditionalInformationDTO::fromDomainObject).typeName(BlobStoreVaultGarbageCollectionTask.TYPE.asString()).withFactory(AdditionalInformationDTOModule::new);
    private final String beginningOfRetentionPeriod;
    private final Collection<String> deletedBuckets;
    private final String type;
    private final Instant timestamp;

    static BlobStoreVaultGarbageCollectionTaskAdditionalInformationDTO fromDomainObject(BlobStoreVaultGarbageCollectionTask.AdditionalInformation additionalInformation, String type) {
        return new BlobStoreVaultGarbageCollectionTaskAdditionalInformationDTO(type, additionalInformation.getBeginningOfRetentionPeriod().toString(), additionalInformation.getDeletedBuckets(), additionalInformation.timestamp());
    }

    public static final AdditionalInformationDTOModule<BlobStoreVaultGarbageCollectionTask.AdditionalInformation, BlobStoreVaultGarbageCollectionTaskAdditionalInformationDTO> module() {
        return (AdditionalInformationDTOModule)DTOModule.forDomainObject(BlobStoreVaultGarbageCollectionTask.AdditionalInformation.class).convertToDTO(BlobStoreVaultGarbageCollectionTaskAdditionalInformationDTO.class).toDomainObjectConverter(BlobStoreVaultGarbageCollectionTaskAdditionalInformationDTO::toDomainObject).toDTOConverter(BlobStoreVaultGarbageCollectionTaskAdditionalInformationDTO::fromDomainObject).typeName(BlobStoreVaultGarbageCollectionTask.TYPE.asString()).withFactory(AdditionalInformationDTOModule::new);
    }

    BlobStoreVaultGarbageCollectionTaskAdditionalInformationDTO(@JsonProperty(value="type") String type, @JsonProperty(value="beginningOfRetentionPeriod") String beginningOfRetentionPeriod, @JsonProperty(value="deletedBuckets") Collection<String> deletedBuckets, @JsonProperty(value="timestamp") Instant timestamp) {
        this.type = type;
        this.beginningOfRetentionPeriod = beginningOfRetentionPeriod;
        this.deletedBuckets = deletedBuckets;
        this.timestamp = timestamp;
    }

    BlobStoreVaultGarbageCollectionTask.AdditionalInformation toDomainObject() {
        return new BlobStoreVaultGarbageCollectionTask.AdditionalInformation(ZonedDateTime.parse(this.beginningOfRetentionPeriod), (ImmutableSet<BucketName>)((ImmutableSet)this.deletedBuckets.stream().map(BucketName::of).collect(ImmutableSet.toImmutableSet())), this.timestamp);
    }

    public String getBeginningOfRetentionPeriod() {
        return this.beginningOfRetentionPeriod;
    }

    public Collection<String> getDeletedBuckets() {
        return this.deletedBuckets;
    }

    public String getType() {
        return this.type;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }
}

