/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.metrics.dropwizard;

import com.codahale.metrics.DefaultSettableGauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import org.apache.james.metrics.api.Gauge;
import org.apache.james.metrics.api.GaugeRegistry;

public class DropWizardGaugeRegistry
implements GaugeRegistry {
    private final MetricRegistry metricRegistry;

    @Inject
    public DropWizardGaugeRegistry(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public <T> GaugeRegistry register(String name, Gauge<T> gauge) {
        this.metricRegistry.gauge(name, () -> () -> gauge.get());
        return this;
    }

    @PreDestroy
    public void shutDown() {
        this.metricRegistry.getGauges().keySet().forEach(arg_0 -> ((MetricRegistry)this.metricRegistry).remove(arg_0));
    }

    public <T> GaugeRegistry.SettableGauge<T> settableGauge(String name) {
        DefaultSettableGauge gauge = new DefaultSettableGauge();
        this.metricRegistry.register(name, (Metric)gauge);
        return arg_0 -> ((DefaultSettableGauge)gauge).setValue(arg_0);
    }
}

