/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonEnum;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.SpanContainingQuery;
import org.opensearch.client.opensearch._types.query_dsl.SpanFieldMaskingQuery;
import org.opensearch.client.opensearch._types.query_dsl.SpanFirstQuery;
import org.opensearch.client.opensearch._types.query_dsl.SpanGapQuery;
import org.opensearch.client.opensearch._types.query_dsl.SpanMultiTermQuery;
import org.opensearch.client.opensearch._types.query_dsl.SpanNearQuery;
import org.opensearch.client.opensearch._types.query_dsl.SpanNotQuery;
import org.opensearch.client.opensearch._types.query_dsl.SpanOrQuery;
import org.opensearch.client.opensearch._types.query_dsl.SpanQueryVariant;
import org.opensearch.client.opensearch._types.query_dsl.SpanTermQuery;
import org.opensearch.client.opensearch._types.query_dsl.SpanWithinQuery;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class SpanQuery
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<SpanQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SpanQuery::setupSpanQueryDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public SpanQuery(SpanQueryVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._spanQueryKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private SpanQuery(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static SpanQuery of(Function<Builder, ObjectBuilder<SpanQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isSpanContaining() {
        return this._kind == Kind.SpanContaining;
    }

    public SpanContainingQuery spanContaining() {
        return (SpanContainingQuery)TaggedUnionUtils.get(this, Kind.SpanContaining);
    }

    public boolean isFieldMaskingSpan() {
        return this._kind == Kind.FieldMaskingSpan;
    }

    public SpanFieldMaskingQuery fieldMaskingSpan() {
        return (SpanFieldMaskingQuery)TaggedUnionUtils.get(this, Kind.FieldMaskingSpan);
    }

    public boolean isSpanFirst() {
        return this._kind == Kind.SpanFirst;
    }

    public SpanFirstQuery spanFirst() {
        return (SpanFirstQuery)TaggedUnionUtils.get(this, Kind.SpanFirst);
    }

    public boolean isSpanGap() {
        return this._kind == Kind.SpanGap;
    }

    public SpanGapQuery spanGap() {
        return (SpanGapQuery)TaggedUnionUtils.get(this, Kind.SpanGap);
    }

    public boolean isSpanMulti() {
        return this._kind == Kind.SpanMulti;
    }

    public SpanMultiTermQuery spanMulti() {
        return (SpanMultiTermQuery)TaggedUnionUtils.get(this, Kind.SpanMulti);
    }

    public boolean isSpanNear() {
        return this._kind == Kind.SpanNear;
    }

    public SpanNearQuery spanNear() {
        return (SpanNearQuery)TaggedUnionUtils.get(this, Kind.SpanNear);
    }

    public boolean isSpanNot() {
        return this._kind == Kind.SpanNot;
    }

    public SpanNotQuery spanNot() {
        return (SpanNotQuery)TaggedUnionUtils.get(this, Kind.SpanNot);
    }

    public boolean isSpanOr() {
        return this._kind == Kind.SpanOr;
    }

    public SpanOrQuery spanOr() {
        return (SpanOrQuery)TaggedUnionUtils.get(this, Kind.SpanOr);
    }

    public boolean isSpanTerm() {
        return this._kind == Kind.SpanTerm;
    }

    public SpanTermQuery spanTerm() {
        return (SpanTermQuery)TaggedUnionUtils.get(this, Kind.SpanTerm);
    }

    public boolean isSpanWithin() {
        return this._kind == Kind.SpanWithin;
    }

    public SpanWithinQuery spanWithin() {
        return (SpanWithinQuery)TaggedUnionUtils.get(this, Kind.SpanWithin);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public Builder toBuilder() {
        return new Builder()._kind(this._kind)._value(this._value);
    }

    protected static void setupSpanQueryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::spanContaining, SpanContainingQuery._DESERIALIZER, "span_containing");
        op.add(Builder::fieldMaskingSpan, SpanFieldMaskingQuery._DESERIALIZER, "field_masking_span");
        op.add(Builder::spanFirst, SpanFirstQuery._DESERIALIZER, "span_first");
        op.add(Builder::spanGap, SpanGapQuery._DESERIALIZER, "span_gap");
        op.add(Builder::spanMulti, SpanMultiTermQuery._DESERIALIZER, "span_multi");
        op.add(Builder::spanNear, SpanNearQuery._DESERIALIZER, "span_near");
        op.add(Builder::spanNot, SpanNotQuery._DESERIALIZER, "span_not");
        op.add(Builder::spanOr, SpanOrQuery._DESERIALIZER, "span_or");
        op.add(Builder::spanTerm, SpanTermQuery._DESERIALIZER, "span_term");
        op.add(Builder::spanWithin, SpanWithinQuery._DESERIALIZER, "span_within");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<SpanQuery> {
        private Kind _kind;
        private Object _value;

        protected final Builder _kind(Kind v) {
            this._kind = v;
            return this;
        }

        protected final Builder _value(Object v) {
            this._value = v;
            return this;
        }

        public ObjectBuilder<SpanQuery> spanContaining(SpanContainingQuery v) {
            this._kind = Kind.SpanContaining;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SpanQuery> spanContaining(Function<SpanContainingQuery.Builder, ObjectBuilder<SpanContainingQuery>> fn) {
            return this.spanContaining(fn.apply(new SpanContainingQuery.Builder()).build());
        }

        public ObjectBuilder<SpanQuery> fieldMaskingSpan(SpanFieldMaskingQuery v) {
            this._kind = Kind.FieldMaskingSpan;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SpanQuery> fieldMaskingSpan(Function<SpanFieldMaskingQuery.Builder, ObjectBuilder<SpanFieldMaskingQuery>> fn) {
            return this.fieldMaskingSpan(fn.apply(new SpanFieldMaskingQuery.Builder()).build());
        }

        public ObjectBuilder<SpanQuery> spanFirst(SpanFirstQuery v) {
            this._kind = Kind.SpanFirst;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SpanQuery> spanFirst(Function<SpanFirstQuery.Builder, ObjectBuilder<SpanFirstQuery>> fn) {
            return this.spanFirst(fn.apply(new SpanFirstQuery.Builder()).build());
        }

        public ObjectBuilder<SpanQuery> spanGap(SpanGapQuery v) {
            this._kind = Kind.SpanGap;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SpanQuery> spanGap(Function<SpanGapQuery.Builder, ObjectBuilder<SpanGapQuery>> fn) {
            return this.spanGap(fn.apply(new SpanGapQuery.Builder()).build());
        }

        public ObjectBuilder<SpanQuery> spanMulti(SpanMultiTermQuery v) {
            this._kind = Kind.SpanMulti;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SpanQuery> spanMulti(Function<SpanMultiTermQuery.Builder, ObjectBuilder<SpanMultiTermQuery>> fn) {
            return this.spanMulti(fn.apply(new SpanMultiTermQuery.Builder()).build());
        }

        public ObjectBuilder<SpanQuery> spanNear(SpanNearQuery v) {
            this._kind = Kind.SpanNear;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SpanQuery> spanNear(Function<SpanNearQuery.Builder, ObjectBuilder<SpanNearQuery>> fn) {
            return this.spanNear(fn.apply(new SpanNearQuery.Builder()).build());
        }

        public ObjectBuilder<SpanQuery> spanNot(SpanNotQuery v) {
            this._kind = Kind.SpanNot;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SpanQuery> spanNot(Function<SpanNotQuery.Builder, ObjectBuilder<SpanNotQuery>> fn) {
            return this.spanNot(fn.apply(new SpanNotQuery.Builder()).build());
        }

        public ObjectBuilder<SpanQuery> spanOr(SpanOrQuery v) {
            this._kind = Kind.SpanOr;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SpanQuery> spanOr(Function<SpanOrQuery.Builder, ObjectBuilder<SpanOrQuery>> fn) {
            return this.spanOr(fn.apply(new SpanOrQuery.Builder()).build());
        }

        public ObjectBuilder<SpanQuery> spanTerm(SpanTermQuery v) {
            this._kind = Kind.SpanTerm;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SpanQuery> spanTerm(Function<SpanTermQuery.Builder, ObjectBuilder<SpanTermQuery>> fn) {
            return this.spanTerm(fn.apply(new SpanTermQuery.Builder()).build());
        }

        public ObjectBuilder<SpanQuery> spanWithin(SpanWithinQuery v) {
            this._kind = Kind.SpanWithin;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SpanQuery> spanWithin(Function<SpanWithinQuery.Builder, ObjectBuilder<SpanWithinQuery>> fn) {
            return this.spanWithin(fn.apply(new SpanWithinQuery.Builder()).build());
        }

        @Override
        public SpanQuery build() {
            this._checkSingleUse();
            return new SpanQuery(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        SpanContaining("span_containing"),
        FieldMaskingSpan("field_masking_span"),
        SpanFirst("span_first"),
        SpanGap("span_gap"),
        SpanMulti("span_multi"),
        SpanNear("span_near"),
        SpanNot("span_not"),
        SpanOr("span_or"),
        SpanTerm("span_term"),
        SpanWithin("span_within");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

