/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenizerBase;
import org.opensearch.client.opensearch._types.analysis.TokenizerDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenizerDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class CharGroupTokenizer
extends TokenizerBase
implements TokenizerDefinitionVariant,
ToCopyableBuilder<Builder, CharGroupTokenizer> {
    @Nullable
    private final Integer maxTokenLength;
    @Nonnull
    private final List<String> tokenizeOnChars;
    public static final JsonpDeserializer<CharGroupTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CharGroupTokenizer::setupCharGroupTokenizerDeserializer);

    private CharGroupTokenizer(Builder builder) {
        super(builder);
        this.maxTokenLength = builder.maxTokenLength;
        this.tokenizeOnChars = ApiTypeHelper.unmodifiableRequired(builder.tokenizeOnChars, (Object)this, "tokenizeOnChars");
    }

    public static CharGroupTokenizer of(Function<Builder, ObjectBuilder<CharGroupTokenizer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenizerDefinition.Kind _tokenizerDefinitionKind() {
        return TokenizerDefinition.Kind.CharGroup;
    }

    @Nullable
    public final Integer maxTokenLength() {
        return this.maxTokenLength;
    }

    @Nonnull
    public final List<String> tokenizeOnChars() {
        return this.tokenizeOnChars;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "char_group");
        super.serializeInternal(generator, mapper);
        if (this.maxTokenLength != null) {
            generator.writeKey("max_token_length");
            generator.write(this.maxTokenLength.intValue());
        }
        generator.writeKey("tokenize_on_chars");
        generator.writeStartArray();
        for (String item0 : this.tokenizeOnChars) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCharGroupTokenizerDeserializer(ObjectDeserializer<Builder> op) {
        CharGroupTokenizer.setupTokenizerBaseDeserializer(op);
        op.add(Builder::maxTokenLength, JsonpDeserializer.integerDeserializer(), "max_token_length");
        op.add(Builder::tokenizeOnChars, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "tokenize_on_chars");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.maxTokenLength);
        result = 31 * result + this.tokenizeOnChars.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharGroupTokenizer other = (CharGroupTokenizer)o;
        return Objects.equals(this.maxTokenLength, other.maxTokenLength) && this.tokenizeOnChars.equals(other.tokenizeOnChars);
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, CharGroupTokenizer> {
        @Nullable
        private Integer maxTokenLength;
        private List<String> tokenizeOnChars;

        public Builder() {
        }

        private Builder(CharGroupTokenizer o) {
            super(o);
            this.maxTokenLength = o.maxTokenLength;
            this.tokenizeOnChars = Builder._listCopy(o.tokenizeOnChars);
        }

        private Builder(Builder o) {
            super(o);
            this.maxTokenLength = o.maxTokenLength;
            this.tokenizeOnChars = Builder._listCopy(o.tokenizeOnChars);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder maxTokenLength(@Nullable Integer value) {
            this.maxTokenLength = value;
            return this;
        }

        @Nonnull
        public final Builder tokenizeOnChars(List<String> list) {
            this.tokenizeOnChars = Builder._listAddAll(this.tokenizeOnChars, list);
            return this;
        }

        @Nonnull
        public final Builder tokenizeOnChars(String value, String ... values) {
            this.tokenizeOnChars = Builder._listAdd(this.tokenizeOnChars, value, values);
            return this;
        }

        @Override
        @Nonnull
        public CharGroupTokenizer build() {
            this._checkSingleUse();
            return new CharGroupTokenizer(this);
        }
    }
}

