/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.r2dbc.postgresql.codec.Point;
import io.r2dbc.postgresql.util.Assert;
import java.util.Objects;

public final class Line {
    private final double a;
    private final double b;
    private final double c;

    private Line(double a, double b, double c) {
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public static Line of(double a, double b, double c) {
        return new Line(a, b, c);
    }

    public static Line of(Point p1, Point p2) {
        Assert.requireNonNull(p1, "p1 must not be null");
        Assert.requireNonNull(p2, "p2 must not be null");
        return Line.of(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static Line of(double x1, double y1, double x2, double y2) {
        double b;
        double a;
        if (x1 == x2) {
            a = -1.0;
            b = 0.0;
        } else {
            a = (y2 - y1) / (x2 - x1);
            b = -1.0;
        }
        double c = y1 - a * x1;
        return Line.of(a, b, c);
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getC() {
        return this.c;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Line line = (Line)o;
        return Double.compare(line.a, this.a) == 0 && Double.compare(line.b, this.b) == 0 && Double.compare(line.c, this.c) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.a, this.b, this.c);
    }

    public String toString() {
        return "{" + this.a + "," + this.b + "," + this.c + "}";
    }
}

