/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.core;

import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.james.core.Username;
import org.apache.james.jmap.core.AccountId;
import org.apache.james.jmap.core.AccountId$;
import org.apache.james.jmap.method.AccountNotFoundException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.exception.ForbiddenDelegationException;
import org.apache.james.util.ReactorUtils;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function1;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005m3Aa\u0002\u0005\u0001'!A!\u0004\u0001B\u0001B\u0003%1\u0004C\u0003\"\u0001\u0011\u0005!\u0005C\u00030\u0001\u0011\u0005\u0001\u0007C\u0003F\u0001\u0011%a\tC\u0003M\u0001\u0011%Q\nC\u0003X\u0001\u0011%\u0001LA\tTKN\u001c\u0018n\u001c8Ue\u0006t7\u000f\\1u_JT!!\u0003\u0006\u0002\t\r|'/\u001a\u0006\u0003\u00171\tAA[7ba*\u0011QBD\u0001\u0006U\u0006lWm\u001d\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g-A\btKN\u001c\u0018n\u001c8Qe>4\u0018\u000eZ3s!\tar$D\u0001\u001e\u0015\tqB\"A\u0004nC&d'm\u001c=\n\u0005\u0001j\"aD*fgNLwN\u001c)s_ZLG-\u001a:\u0002\rqJg.\u001b;?)\t\u0019S\u0005\u0005\u0002%\u00015\t\u0001\u0002C\u0003\u001b\u0005\u0001\u00071\u0004\u000b\u0002\u0003OA\u0011\u0001&L\u0007\u0002S)\u0011!fK\u0001\u0007S:TWm\u0019;\u000b\u00031\nqA[1lCJ$\u0018-\u0003\u0002/S\t1\u0011J\u001c6fGR\f\u0001\u0003Z3mK\u001e\fG/Z%g\u001d\u0016,G-\u001a3\u0015\u0007Er\u0004\tE\u00023smj\u0011a\r\u0006\u0003iU\n\u0011\u0002];cY&\u001c\b.\u001a:\u000b\u0005]1$BA\u00058\u0015\u0005A\u0014a\u0002:fC\u000e$xN]\u0005\u0003uM\u0012QaU'p]>\u0004\"\u0001\b\u001f\n\u0005uj\"AD'bS2\u0014w\u000e_*fgNLwN\u001c\u0005\u0006\u007f\r\u0001\raO\u0001\bg\u0016\u001c8/[8o\u0011\u0015\t5\u00011\u0001C\u0003=!\u0018M]4fi\u0006\u001b7m\\;oi&#\u0007C\u0001\u0013D\u0013\t!\u0005BA\u0005BG\u000e|WO\u001c;JI\u0006qa.Z3e\t\u0016dWmZ1uS>tGcA$K\u0017B\u0011Q\u0003S\u0005\u0003\u0013Z\u0011qAQ8pY\u0016\fg\u000eC\u0003@\t\u0001\u00071\bC\u0003B\t\u0001\u0007!)\u0001\u0007iCN\f5mY8v]RLE\r\u0006\u0002O-R\u0011qi\u0014\u0005\u0006!\u0016\u0001\r!U\u0001\tkN,'O\\1nKB\u0011!\u000bV\u0007\u0002'*\u0011\u0011\u0002D\u0005\u0003+N\u0013\u0001\"V:fe:\fW.\u001a\u0005\u0006\u0003\u0016\u0001\rAQ\u0001\tI\u0016dWmZ1uKR\u0019\u0011'\u0017.\t\u000b}2\u0001\u0019A\u001e\t\u000b\u00053\u0001\u0019\u0001\"")
public class SessionTranslator {
    private final SessionProvider sessionProvider;

    public SMono<MailboxSession> delegateIfNeeded(MailboxSession session, AccountId targetAccountId) {
        if (this.needDelegation(session, targetAccountId)) {
            return this.delegate(session, targetAccountId);
        }
        return SMono$.MODULE$.just((Object)session);
    }

    private boolean needDelegation(MailboxSession session, AccountId targetAccountId) {
        return !this.hasAccountId(targetAccountId, session.getUser());
    }

    private boolean hasAccountId(AccountId targetAccountId, Username username) {
        return AccountId$.MODULE$.from(username).toOption().contains((Object)targetAccountId);
    }

    private SMono<MailboxSession> delegate(MailboxSession session, AccountId targetAccountId) {
        return SMono$.MODULE$.fromCallable(() -> $this.sessionProvider.authenticate(session.getUser()).forMatchingUser(user -> this.hasAccountId(targetAccountId, (Username)user))).onErrorResume((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof ForbiddenDelegationException) {
                return SMono$.MODULE$.error((Throwable)new AccountNotFoundException());
            }
            return SMono$.MODULE$.error(throwable);
        }).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }

    @Inject
    public SessionTranslator(SessionProvider sessionProvider) {
        this.sessionProvider = sessionProvider;
    }
}

