/*
 * Decompiled with CFR 0.152.
 */
package reactor.swing;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.swt.widgets.Display;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;
import reactor.util.context.Context;

@Deprecated
public final class SwtScheduler
implements Scheduler {
    final Display display;

    public static Scheduler from(Display display) {
        Objects.requireNonNull(display, "display");
        return new SwtScheduler(display);
    }

    SwtScheduler(Display display) {
        this.display = display;
    }

    @Override
    public Disposable schedule(Runnable task) {
        SwtScheduledDirectAction a = new SwtScheduledDirectAction(task);
        if (this.display.isDisposed()) {
            throw Exceptions.failWithRejected();
        }
        this.display.asyncExec((Runnable)a);
        return a;
    }

    @Override
    public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
        if (delay <= 0L) {
            return this.schedule(task);
        }
        if (!this.display.isDisposed()) {
            SwtScheduledDirectAction a = new SwtScheduledDirectAction(task);
            this.display.timerExec((int)unit.toMillis(delay), (Runnable)a);
            return a;
        }
        throw Exceptions.failWithRejected();
    }

    @Override
    public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
        if (!this.display.isDisposed()) {
            long initialDelayMillis = unit.toMillis(initialDelay);
            SwtPeriodicDirectAction a = new SwtPeriodicDirectAction(task, this.display, System.currentTimeMillis() + initialDelayMillis, unit.toMillis(period));
            if (initialDelay <= 0L) {
                this.display.asyncExec((Runnable)a);
            } else {
                this.display.timerExec((int)initialDelayMillis, (Runnable)a);
            }
            return a;
        }
        throw Exceptions.failWithRejected();
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new SwtWorker(this.display);
    }

    static final class SwtPeriodicAction
    extends AtomicBoolean
    implements Runnable,
    Disposable {
        private static final long serialVersionUID = 1890399765810263705L;
        final Runnable task;
        final Display display;
        final long periodMillis;
        final long start;
        final SwtWorker parent;
        long count;

        public SwtPeriodicAction(Runnable task, SwtWorker parent, Display display, long start, long periodMillis) {
            this.task = task;
            this.display = display;
            this.start = start;
            this.periodMillis = periodMillis;
            this.parent = parent;
        }

        @Override
        public void run() {
            long next;
            long delta;
            if (this.get() || this.parent.unsubscribed) {
                return;
            }
            try {
                this.task.run();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                Operators.onErrorDropped(ex, Context.empty());
                return;
            }
            if (this.get() || this.parent.unsubscribed) {
                return;
            }
            long now = System.currentTimeMillis();
            if ((delta = Math.max(0L, (next = this.start + ++this.count * this.periodMillis) - now)) == 0L) {
                this.display.asyncExec((Runnable)this);
            } else {
                this.display.timerExec((int)delta, (Runnable)this);
            }
        }

        @Override
        public void dispose() {
            this.set(true);
        }
    }

    static final class SwtPeriodicDirectAction
    extends AtomicBoolean
    implements Runnable,
    Disposable {
        private static final long serialVersionUID = 1890399765810263705L;
        final Runnable task;
        final Display display;
        final long periodMillis;
        final long start;
        long count;

        public SwtPeriodicDirectAction(Runnable task, Display display, long start, long periodMillis) {
            this.task = task;
            this.display = display;
            this.start = start;
            this.periodMillis = periodMillis;
        }

        @Override
        public void run() {
            long next;
            long delta;
            if (this.get()) {
                return;
            }
            try {
                this.task.run();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                Operators.onErrorDropped(ex, Context.empty());
                return;
            }
            if (this.get()) {
                return;
            }
            long now = System.currentTimeMillis();
            if ((delta = Math.max(0L, (next = this.start + ++this.count * this.periodMillis) - now)) == 0L) {
                this.display.asyncExec((Runnable)this);
            } else {
                this.display.timerExec((int)delta, (Runnable)this);
            }
        }

        @Override
        public void dispose() {
            this.set(true);
        }
    }

    static final class SwtScheduledDirectAction
    extends AtomicBoolean
    implements Runnable,
    Disposable {
        private static final long serialVersionUID = 2378266891882031635L;
        final Runnable action;

        public SwtScheduledDirectAction(Runnable action) {
            this.action = action;
        }

        @Override
        public void run() {
            if (!this.get()) {
                try {
                    this.action.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    Operators.onErrorDropped(ex, Context.empty());
                }
            }
        }

        @Override
        public void dispose() {
            this.set(true);
        }
    }

    static final class SwtWorker
    implements Scheduler.Worker {
        final Display display;
        volatile boolean unsubscribed;

        SwtWorker(Display display) {
            this.display = display;
        }

        @Override
        public void dispose() {
            if (this.unsubscribed) {
                return;
            }
            this.unsubscribed = true;
        }

        @Override
        public Disposable schedule(Runnable action) {
            if (!this.unsubscribed && !this.display.isDisposed()) {
                SwtScheduledAction a = new SwtScheduledAction(action, this);
                this.display.asyncExec((Runnable)a);
                return a;
            }
            throw Exceptions.failWithRejected();
        }

        @Override
        public Disposable schedule(Runnable action, long delayTime, TimeUnit unit) {
            if (delayTime <= 0L) {
                return this.schedule(action);
            }
            if (!this.unsubscribed && !this.display.isDisposed()) {
                SwtScheduledAction a = new SwtScheduledAction(action, this);
                this.display.timerExec((int)unit.toMillis(delayTime), (Runnable)a);
                return a;
            }
            throw Exceptions.failWithRejected();
        }

        @Override
        public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
            if (!this.display.isDisposed()) {
                long initialDelayMillis = unit.toMillis(initialDelay);
                SwtPeriodicAction a = new SwtPeriodicAction(task, this, this.display, System.currentTimeMillis() + initialDelayMillis, unit.toMillis(period));
                if (initialDelay <= 0L) {
                    this.display.asyncExec((Runnable)a);
                } else {
                    this.display.timerExec((int)initialDelayMillis, (Runnable)a);
                }
                return a;
            }
            throw Exceptions.failWithRejected();
        }

        static final class SwtScheduledAction
        extends AtomicBoolean
        implements Runnable,
        Disposable {
            private static final long serialVersionUID = -2864452628218128444L;
            final Runnable action;
            final SwtWorker parent;

            public SwtScheduledAction(Runnable action, SwtWorker parent) {
                this.action = action;
                this.parent = parent;
            }

            @Override
            public void run() {
                if (!this.parent.unsubscribed && !this.get()) {
                    try {
                        this.action.run();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        Operators.onErrorDropped(ex, Context.empty());
                    }
                }
            }

            @Override
            public void dispose() {
                this.set(true);
            }
        }
    }
}

