/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.lifecycle.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;

public interface StartUpCheck {
    public CheckResult check();

    public String checkName();

    public static class CheckResult {
        private final String name;
        private final ResultType resultType;
        private final Optional<String> description;

        public static Builder.RequireCheckName builder() {
            return name -> resultType -> new Builder.ReadyToBuild(name, resultType);
        }

        private CheckResult(String name, ResultType resultType, Optional<String> description) {
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkNotNull((Object)((Object)resultType));
            Preconditions.checkNotNull(description);
            this.name = name;
            this.resultType = resultType;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public ResultType getResultType() {
            return this.resultType;
        }

        public Optional<String> getDescription() {
            return this.description;
        }

        public boolean isBad() {
            return this.resultType.equals((Object)ResultType.BAD);
        }

        public boolean isGood() {
            return this.resultType.equals((Object)ResultType.GOOD);
        }

        public final boolean equals(Object o) {
            if (o instanceof CheckResult) {
                CheckResult that = (CheckResult)o;
                return Objects.equals(this.name, that.name) && Objects.equals((Object)this.resultType, (Object)that.resultType) && Objects.equals(this.description, that.description);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.name, this.resultType, this.description});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("resultType", (Object)this.resultType).add("description", this.description).toString();
        }

        public static class Builder {

            public static class ReadyToBuild {
                private final String name;
                private final ResultType resultType;
                private Optional<String> description;

                ReadyToBuild(String name, ResultType resultType) {
                    this.name = name;
                    this.resultType = resultType;
                    this.description = Optional.empty();
                }

                public ReadyToBuild description(String description) {
                    this.description = Optional.ofNullable(description);
                    return this;
                }

                public CheckResult build() {
                    return new CheckResult(this.name, this.resultType, this.description);
                }
            }

            @FunctionalInterface
            public static interface RequireResultType {
                public ReadyToBuild resultType(ResultType var1);
            }

            @FunctionalInterface
            public static interface RequireCheckName {
                public RequireResultType checkName(String var1);
            }
        }
    }

    public static enum ResultType {
        GOOD,
        BAD;

    }
}

