/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.mailbox.extension.PreDeletionHook;

public class PreDeletionHookConfiguration {
    public static final String CLASS_NAME_CONFIGURATION_ENTRY = "class";
    private final String clazz;

    public static PreDeletionHookConfiguration from(HierarchicalConfiguration<ImmutableNode> configuration) throws ConfigurationException {
        Preconditions.checkNotNull(configuration);
        try {
            return PreDeletionHookConfiguration.forClass(configuration.getString(CLASS_NAME_CONFIGURATION_ENTRY));
        }
        catch (Exception e) {
            throw new ConfigurationException("Exception encountered in PreDeletionHook configuration", (Throwable)e);
        }
    }

    public static PreDeletionHookConfiguration forClass(Class<? extends PreDeletionHook> clazz) {
        return PreDeletionHookConfiguration.forClass(clazz.getName());
    }

    public static PreDeletionHookConfiguration forClass(String clazz) {
        return new PreDeletionHookConfiguration(clazz);
    }

    private PreDeletionHookConfiguration(String clazz) {
        Preconditions.checkNotNull((Object)clazz, (Object)"class name is mandatory");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)clazz) ? 1 : 0) != 0, (Object)"class name should not be empty");
        this.clazz = clazz;
    }

    public String getClazz() {
        return this.clazz;
    }

    public final boolean equals(Object o) {
        if (o instanceof PreDeletionHookConfiguration) {
            PreDeletionHookConfiguration that = (PreDeletionHookConfiguration)o;
            return Objects.equals(this.clazz, that.clazz);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.clazz);
    }
}

