/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import com.github.fge.lambdas.Throwing;
import java.util.Optional;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.mailbox.Mailbox;
import org.apache.james.util.MDCBuilder;

public interface MDCConstants {
    public static final String MAILBOX = "mailbox";
    public static final String ARGUMENT = "argument";
    public static final String STATE = "state";

    public static MDCBuilder withMailbox(POP3Session session) {
        return Optional.ofNullable(session.getUserMailbox()).map(Throwing.function(Mailbox::getIdentifier).sneakyThrow()).map(id -> MDCBuilder.create().addToContext(MAILBOX, id)).orElseGet(MDCBuilder::create);
    }

    public static MDCBuilder forRequest(Request request) {
        return Optional.ofNullable(request.getArgument()).map(argument -> MDCBuilder.create().addToContext(ARGUMENT, argument)).orElseGet(MDCBuilder::create);
    }

    public static MDCBuilder withSession(POP3Session session) {
        return MDCBuilder.create().addToContext(MDCConstants.withMailbox(session)).addToContext(STATE, Integer.toString(session.getHandlerState()));
    }
}

