/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import java.time.Clock;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.james.webadmin.service.EventDeadLettersRedeliverService;
import org.apache.james.webadmin.service.EventDeadLettersRedeliveryTaskAdditionalInformation;
import org.apache.james.webadmin.service.EventDeadLettersRedeliveryTaskAdditionalInformationDTO;
import org.apache.james.webadmin.service.EventRetriever;

public class EventDeadLettersRedeliverAllTask
implements Task {
    public static final TaskType TYPE = TaskType.of((String)"event-dead-letters-redeliver-all");
    private final EventDeadLettersRedeliverService service;
    private final EventRetriever eventRetriever;
    private final AtomicLong successfulRedeliveriesCount;
    private final AtomicLong failedRedeliveriesCount;
    private final EventDeadLettersRedeliverService.RunningOptions runningOptions;

    EventDeadLettersRedeliverAllTask(EventDeadLettersRedeliverService service, EventDeadLettersRedeliverService.RunningOptions runningOptions) {
        this.service = service;
        this.eventRetriever = EventRetriever.allEvents();
        this.successfulRedeliveriesCount = new AtomicLong(0L);
        this.failedRedeliveriesCount = new AtomicLong(0L);
        this.runningOptions = runningOptions;
    }

    public Task.Result run() {
        return (Task.Result)this.service.redeliverEvents(this.eventRetriever, this.runningOptions).map(this::updateCounters).reduce((Object)Task.Result.COMPLETED, Task::combine).block();
    }

    private Task.Result updateCounters(Task.Result result) {
        switch (result) {
            case COMPLETED: {
                this.successfulRedeliveriesCount.incrementAndGet();
                break;
            }
            case PARTIAL: {
                this.failedRedeliveriesCount.incrementAndGet();
                break;
            }
            default: {
                throw new RuntimeException("Result case: " + result.toString() + " not recognized");
            }
        }
        return result;
    }

    public TaskType type() {
        return TYPE;
    }

    public EventDeadLettersRedeliverService.RunningOptions getRunningOptions() {
        return this.runningOptions;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(this.createAdditionalInformation());
    }

    private EventDeadLettersRedeliveryTaskAdditionalInformation createAdditionalInformation() {
        return new EventDeadLettersRedeliveryTaskAdditionalInformationDTO.EventDeadLettersRedeliveryTaskAdditionalInformationForAll(this.successfulRedeliveriesCount.get(), this.failedRedeliveriesCount.get(), Clock.systemUTC().instant(), this.getRunningOptions());
    }
}

