/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.MultiBucketBase;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class RangeBucket
extends MultiBucketBase {
    @Nullable
    private final Double from;
    @Nullable
    private final Double to;
    @Nullable
    private final String fromAsString;
    @Nullable
    private final String toAsString;
    public static final JsonpDeserializer<RangeBucket> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RangeBucket::setupRangeBucketDeserializer);

    private RangeBucket(Builder builder) {
        super(builder);
        this.from = builder.from;
        this.to = builder.to;
        this.fromAsString = builder.fromAsString;
        this.toAsString = builder.toAsString;
    }

    public static RangeBucket of(Function<Builder, ObjectBuilder<RangeBucket>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Double from() {
        return this.from;
    }

    @Nullable
    public final Double to() {
        return this.to;
    }

    @Nullable
    public final String fromAsString() {
        return this.fromAsString;
    }

    @Nullable
    public final String toAsString() {
        return this.toAsString;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.from != null) {
            generator.writeKey("from");
            generator.write(this.from.doubleValue());
        }
        if (this.to != null) {
            generator.writeKey("to");
            generator.write(this.to.doubleValue());
        }
        if (this.fromAsString != null) {
            generator.writeKey("from_as_string");
            generator.write(this.fromAsString);
        }
        if (this.toAsString != null) {
            generator.writeKey("to_as_string");
            generator.write(this.toAsString);
        }
    }

    protected static void setupRangeBucketDeserializer(ObjectDeserializer<Builder> op) {
        RangeBucket.setupMultiBucketBaseDeserializer(op);
        op.add(Builder::from, JsonpDeserializer.doubleDeserializer(), "from");
        op.add(Builder::to, JsonpDeserializer.doubleDeserializer(), "to");
        op.add(Builder::fromAsString, JsonpDeserializer.stringDeserializer(), "from_as_string");
        op.add(Builder::toAsString, JsonpDeserializer.stringDeserializer(), "to_as_string");
    }

    public static class Builder
    extends MultiBucketBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RangeBucket> {
        @Nullable
        private Double from;
        @Nullable
        private Double to;
        @Nullable
        private String fromAsString;
        @Nullable
        private String toAsString;

        public final Builder from(@Nullable Double value) {
            this.from = value;
            return this;
        }

        public final Builder to(@Nullable Double value) {
            this.to = value;
            return this;
        }

        public final Builder fromAsString(@Nullable String value) {
            this.fromAsString = value;
            return this;
        }

        public final Builder toAsString(@Nullable String value) {
            this.toAsString = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RangeBucket build() {
            this._checkSingleUse();
            return new RangeBucket(this);
        }
    }
}

