/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.BucketAggregationBase;
import org.opensearch.client.opensearch._types.aggregations.IpRangeAggregationRange;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class IpRangeAggregation
extends BucketAggregationBase
implements AggregationVariant {
    @Nullable
    private final String field;
    private final List<IpRangeAggregationRange> ranges;
    public static final JsonpDeserializer<IpRangeAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IpRangeAggregation::setupIpRangeAggregationDeserializer);

    private IpRangeAggregation(Builder builder) {
        super(builder);
        this.field = builder.field;
        this.ranges = ApiTypeHelper.unmodifiable(builder.ranges);
    }

    public static IpRangeAggregation of(Function<Builder, ObjectBuilder<IpRangeAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.IpRange;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    public final List<IpRangeAggregationRange> ranges() {
        return this.ranges;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (ApiTypeHelper.isDefined(this.ranges)) {
            generator.writeKey("ranges");
            generator.writeStartArray();
            for (IpRangeAggregationRange item0 : this.ranges) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupIpRangeAggregationDeserializer(ObjectDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::ranges, JsonpDeserializer.arrayDeserializer(IpRangeAggregationRange._DESERIALIZER), "ranges");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<IpRangeAggregation> {
        @Nullable
        private String field;
        @Nullable
        private List<IpRangeAggregationRange> ranges;

        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public final Builder ranges(List<IpRangeAggregationRange> list) {
            this.ranges = Builder._listAddAll(this.ranges, list);
            return this;
        }

        public final Builder ranges(IpRangeAggregationRange value, IpRangeAggregationRange ... values) {
            this.ranges = Builder._listAdd(this.ranges, value, values);
            return this;
        }

        public final Builder ranges(Function<IpRangeAggregationRange.Builder, ObjectBuilder<IpRangeAggregationRange>> fn) {
            return this.ranges(fn.apply(new IpRangeAggregationRange.Builder()).build(), new IpRangeAggregationRange[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IpRangeAggregation build() {
            this._checkSingleUse();
            return new IpRangeAggregation(this);
        }
    }
}

