/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.cassandra;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.configuration.JamesExecutionProfiles;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.cassandra.BlobTables;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraDefaultBucketDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement insert;
    private final PreparedStatement insertPart;
    private final PreparedStatement select;
    private final PreparedStatement selectPart;
    private final PreparedStatement delete;
    private final PreparedStatement deleteParts;
    private final PreparedStatement listBlobs;
    private final BlobId.Factory blobIdFactory;
    private final DriverExecutionProfile optimisticConsistencyLevelProfile;

    @Inject
    @VisibleForTesting
    public CassandraDefaultBucketDAO(CqlSession session, BlobId.Factory blobIdFactory) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.blobIdFactory = blobIdFactory;
        this.insert = session.prepare(QueryBuilder.insertInto((String)"blobs").value(BlobTables.DefaultBucketBlobTable.ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.DefaultBucketBlobTable.ID)).value(BlobTables.DefaultBucketBlobTable.NUMBER_OF_CHUNK, (Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.DefaultBucketBlobTable.NUMBER_OF_CHUNK)).build());
        this.select = session.prepare(((Select)QueryBuilder.selectFrom((String)"blobs").all().whereColumn(BlobTables.DefaultBucketBlobTable.ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.DefaultBucketBlobTable.ID))).build());
        this.insertPart = session.prepare(QueryBuilder.insertInto((String)"blobParts").value(BlobTables.DefaultBucketBlobParts.ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.DefaultBucketBlobParts.ID)).value(BlobTables.DefaultBucketBlobParts.CHUNK_NUMBER, (Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.DefaultBucketBlobParts.CHUNK_NUMBER)).value(BlobTables.DefaultBucketBlobParts.DATA, (Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.DefaultBucketBlobParts.DATA)).build());
        this.selectPart = session.prepare(((Select)((Select)QueryBuilder.selectFrom((String)"blobParts").all().whereColumn(BlobTables.DefaultBucketBlobParts.ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.DefaultBucketBlobParts.ID))).whereColumn(BlobTables.DefaultBucketBlobParts.CHUNK_NUMBER).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.DefaultBucketBlobParts.CHUNK_NUMBER))).build());
        this.delete = session.prepare(((Delete)QueryBuilder.deleteFrom((String)"blobs").whereColumn(BlobTables.DefaultBucketBlobTable.ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.DefaultBucketBlobTable.ID))).build());
        this.deleteParts = session.prepare(((Delete)QueryBuilder.deleteFrom((String)"blobParts").whereColumn(BlobTables.DefaultBucketBlobParts.ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.DefaultBucketBlobParts.ID))).build());
        this.listBlobs = session.prepare(QueryBuilder.selectFrom((String)"blobParts").column(BlobTables.DefaultBucketBlobParts.ID).build());
        this.optimisticConsistencyLevelProfile = JamesExecutionProfiles.getOptimisticConsistencyLevelProfile((CqlSession)session);
    }

    Mono<Void> writePart(ByteBuffer data, BlobId blobId, int position) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.insertPart.bind(new Object[0]).setString(BlobTables.DefaultBucketBlobTable.ID, blobId.asString())).setInt(BlobTables.DefaultBucketBlobParts.CHUNK_NUMBER, position)).setByteBuffer(BlobTables.DefaultBucketBlobParts.DATA, data));
    }

    Mono<Void> saveBlobPartsReferences(BlobId blobId, int numberOfChunk) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.insert.bind(new Object[0]).setString(BlobTables.DefaultBucketBlobTable.ID, blobId.asString())).setInt(BlobTables.DefaultBucketBlobTable.NUMBER_OF_CHUNK, numberOfChunk));
    }

    Mono<Integer> selectRowCount(BlobId blobId) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.select.bind(new Object[0]).setString(BlobTables.DefaultBucketBlobTable.ID, blobId.asString())).map(row -> row.getInt(BlobTables.DefaultBucketBlobTable.NUMBER_OF_CHUNK));
    }

    Mono<Integer> selectRowCountClOne(BlobId blobId) {
        return this.cassandraAsyncExecutor.executeSingleRow(((BoundStatement)this.select.bind(new Object[0]).setString(BlobTables.DefaultBucketBlobTable.ID, blobId.asString())).setExecutionProfile(this.optimisticConsistencyLevelProfile)).map(row -> row.getInt(BlobTables.DefaultBucketBlobTable.NUMBER_OF_CHUNK));
    }

    Mono<ByteBuffer> readPart(BlobId blobId, int position) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)((BoundStatement)this.selectPart.bind(new Object[0]).setString(BlobTables.DefaultBucketBlobParts.ID, blobId.asString())).setInt(BlobTables.DefaultBucketBlobParts.CHUNK_NUMBER, position)).map(this::rowToData);
    }

    Mono<ByteBuffer> readPartClOne(BlobId blobId, int position) {
        return this.cassandraAsyncExecutor.executeSingleRow(((BoundStatement)((BoundStatement)this.selectPart.bind(new Object[0]).setString(BlobTables.DefaultBucketBlobParts.ID, blobId.asString())).setInt(BlobTables.DefaultBucketBlobParts.CHUNK_NUMBER, position)).setExecutionProfile(this.optimisticConsistencyLevelProfile)).map(this::rowToData);
    }

    Mono<Void> deletePosition(BlobId blobId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.delete.bind(new Object[0]).setString(BlobTables.DefaultBucketBlobTable.ID, blobId.asString()));
    }

    Mono<Void> deleteParts(BlobId blobId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.deleteParts.bind(new Object[0]).setString(BlobTables.DefaultBucketBlobParts.ID, blobId.asString()));
    }

    Flux<BlobId> listBlobs() {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.listBlobs.bind(new Object[0])).map(row -> this.blobIdFactory.from(row.getString(BlobTables.DefaultBucketBlobParts.ID)));
    }

    private ByteBuffer rowToData(Row row) {
        return row.getByteBuffer(BlobTables.DefaultBucketBlobParts.DATA);
    }
}

