/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.json.DTOModule;
import org.apache.james.rrt.cassandra.CassandraMappingsSourcesDAO;
import org.apache.james.rrt.cassandra.migration.MappingsSourcesMigration;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.reactivestreams.Publisher;

public class CassandraMappingsSolveInconsistenciesTask
implements Task {
    public static final TaskType TYPE = TaskType.of((String)"cassandra-mappings-solve-inconsistencies");
    private final Task mappingsSourcesMigration;
    private final CassandraMappingsSourcesDAO cassandraMappingsSourcesDAO;

    public static TaskDTOModule<CassandraMappingsSolveInconsistenciesTask, CassandraMappingsSolveInconsistenciesTaskDTO> module(MappingsSourcesMigration mappingsSourcesMigration, CassandraMappingsSourcesDAO cassandraMappingsSourcesDAO) {
        return (TaskDTOModule)DTOModule.forDomainObject(CassandraMappingsSolveInconsistenciesTask.class).convertToDTO(CassandraMappingsSolveInconsistenciesTaskDTO.class).toDomainObjectConverter(dto -> new CassandraMappingsSolveInconsistenciesTask(mappingsSourcesMigration, cassandraMappingsSourcesDAO)).toDTOConverter((domainObject, typeName) -> new CassandraMappingsSolveInconsistenciesTaskDTO(typeName)).typeName(TYPE.asString()).withFactory(TaskDTOModule::new);
    }

    @Inject
    CassandraMappingsSolveInconsistenciesTask(MappingsSourcesMigration mappingsSourcesMigration, CassandraMappingsSourcesDAO cassandraMappingsSourcesDAO) {
        this.mappingsSourcesMigration = mappingsSourcesMigration.asTask();
        this.cassandraMappingsSourcesDAO = cassandraMappingsSourcesDAO;
    }

    public Task.Result run() throws InterruptedException {
        this.cassandraMappingsSourcesDAO.removeAllData().doOnError(e -> LOGGER.error("Error while cleaning up data in mappings sources projection table")).block();
        return this.mappingsSourcesMigration.run();
    }

    public TaskType type() {
        return TYPE;
    }

    public Publisher<Optional<TaskExecutionDetails.AdditionalInformation>> detailsReactive() {
        return this.mappingsSourcesMigration.detailsReactive();
    }

    private static class CassandraMappingsSolveInconsistenciesTaskDTO
    implements TaskDTO {
        private final String type;

        public CassandraMappingsSolveInconsistenciesTaskDTO(@JsonProperty(value="type") String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

