/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.array;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.extras.array.AbstractPrimitiveListToArrayCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class BooleanListToArrayCodec
extends AbstractPrimitiveListToArrayCodec<boolean[]> {
    private static final byte TRUE = 1;
    private static final byte FALSE = 0;

    public BooleanListToArrayCodec() {
        super(DataTypes.listOf(DataTypes.BOOLEAN), GenericType.of(boolean[].class));
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        Objects.requireNonNull(javaClass);
        return boolean[].class.equals(javaClass);
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        Objects.requireNonNull(value);
        return value instanceof boolean[];
    }

    @Override
    protected int sizeOfComponentType() {
        return 1;
    }

    @Override
    protected void serializeElement(@NonNull ByteBuffer output, @NonNull boolean[] array, int index, @NonNull ProtocolVersion protocolVersion) {
        byte element = array[index] ? (byte)1 : 0;
        output.put(element);
    }

    @Override
    protected void deserializeElement(@NonNull ByteBuffer input, @NonNull boolean[] array, int index, @NonNull ProtocolVersion protocolVersion) {
        array[index] = input.get() == 1;
    }

    @Override
    protected void formatElement(@NonNull StringBuilder output, @NonNull boolean[] array, int index) {
        output.append(array[index]);
    }

    @Override
    protected void parseElement(@NonNull String input, @NonNull boolean[] array, int index) {
        array[index] = Boolean.parseBoolean(input);
    }

    @Override
    @NonNull
    protected boolean[] newInstance(int size) {
        return new boolean[size];
    }
}

