/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.Analyzer;
import org.opensearch.client.opensearch._types.analysis.AnalyzerVariant;
import org.opensearch.client.opensearch._types.analysis.NoriDecompoundMode;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class NoriAnalyzer
implements AnalyzerVariant,
JsonpSerializable {
    @Nullable
    private final String version;
    @Nullable
    private final NoriDecompoundMode decompoundMode;
    private final List<String> stoptags;
    @Nullable
    private final String userDictionary;
    public static final JsonpDeserializer<NoriAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NoriAnalyzer::setupNoriAnalyzerDeserializer);

    private NoriAnalyzer(Builder builder) {
        this.version = builder.version;
        this.decompoundMode = builder.decompoundMode;
        this.stoptags = ApiTypeHelper.unmodifiable(builder.stoptags);
        this.userDictionary = builder.userDictionary;
    }

    public static NoriAnalyzer of(Function<Builder, ObjectBuilder<NoriAnalyzer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Analyzer.Kind _analyzerKind() {
        return Analyzer.Kind.Nori;
    }

    @Nullable
    public final String version() {
        return this.version;
    }

    @Nullable
    public final NoriDecompoundMode decompoundMode() {
        return this.decompoundMode;
    }

    public final List<String> stoptags() {
        return this.stoptags;
    }

    @Nullable
    public final String userDictionary() {
        return this.userDictionary;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "nori");
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version);
        }
        if (this.decompoundMode != null) {
            generator.writeKey("decompound_mode");
            this.decompoundMode.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.stoptags)) {
            generator.writeKey("stoptags");
            generator.writeStartArray();
            for (String item0 : this.stoptags) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.userDictionary != null) {
            generator.writeKey("user_dictionary");
            generator.write(this.userDictionary);
        }
    }

    protected static void setupNoriAnalyzerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
        op.add(Builder::decompoundMode, NoriDecompoundMode._DESERIALIZER, "decompound_mode");
        op.add(Builder::stoptags, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stoptags");
        op.add(Builder::userDictionary, JsonpDeserializer.stringDeserializer(), "user_dictionary");
        op.ignore("type");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<NoriAnalyzer> {
        @Nullable
        private String version;
        @Nullable
        private NoriDecompoundMode decompoundMode;
        @Nullable
        private List<String> stoptags;
        @Nullable
        private String userDictionary;

        public final Builder version(@Nullable String value) {
            this.version = value;
            return this;
        }

        public final Builder decompoundMode(@Nullable NoriDecompoundMode value) {
            this.decompoundMode = value;
            return this;
        }

        public final Builder stoptags(List<String> list) {
            this.stoptags = Builder._listAddAll(this.stoptags, list);
            return this;
        }

        public final Builder stoptags(String value, String ... values) {
            this.stoptags = Builder._listAdd(this.stoptags, value, values);
            return this;
        }

        public final Builder userDictionary(@Nullable String value) {
            this.userDictionary = value;
            return this;
        }

        @Override
        public NoriAnalyzer build() {
            this._checkSingleUse();
            return new NoriAnalyzer(this);
        }
    }
}

