/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.json;

import jakarta.json.JsonObject;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.opensearch.client.json.DelegatingDeserializer;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpUtils;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.util.ObjectBuilder;

public class UnionDeserializer<Union, Kind, Member>
implements JsonpDeserializer<Union> {
    private final BiFunction<Kind, Member, Union> buildFn;
    private final EnumSet<JsonParser.Event> nativeEvents;
    private final Map<String, EventHandler<Union, Kind, Member>> objectMembers;
    private final Map<JsonParser.Event, EventHandler<Union, Kind, Member>> otherMembers;
    private final EventHandler<Union, Kind, Member> fallbackObjectMember;

    public UnionDeserializer(List<SingleMemberHandler<Union, Kind, Member>> objectMembers, Map<JsonParser.Event, EventHandler<Union, Kind, Member>> otherMembers, BiFunction<Kind, Member, Union> buildFn) {
        this.buildFn = buildFn;
        if (objectMembers.isEmpty()) {
            this.objectMembers = Collections.emptyMap();
        } else {
            this.objectMembers = new HashMap<String, EventHandler<Union, Kind, Member>>();
            for (SingleMemberHandler<Union, Kind, Member> singleMemberHandler : objectMembers) {
                for (String field : singleMemberHandler.fields) {
                    this.objectMembers.put(field, singleMemberHandler);
                }
            }
        }
        this.otherMembers = otherMembers;
        this.nativeEvents = EnumSet.noneOf(JsonParser.Event.class);
        for (EventHandler eventHandler : otherMembers.values()) {
            this.nativeEvents.addAll(eventHandler.nativeEvents());
        }
        if (objectMembers.isEmpty()) {
            this.fallbackObjectMember = null;
        } else {
            this.fallbackObjectMember = this.otherMembers.remove(JsonParser.Event.START_OBJECT);
            this.nativeEvents.add(JsonParser.Event.START_OBJECT);
        }
    }

    @Override
    public EnumSet<JsonParser.Event> nativeEvents() {
        return this.nativeEvents;
    }

    @Override
    public EnumSet<JsonParser.Event> acceptedEvents() {
        return this.nativeEvents;
    }

    @Override
    public Union deserialize(JsonParser parser, JsonpMapper mapper) {
        JsonParser.Event event = parser.next();
        JsonpUtils.ensureAccepts(this, parser, event);
        return this.deserialize(parser, mapper, event);
    }

    @Override
    public Union deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
        EventHandler<Union, Kind, Member> member = this.otherMembers.get(event);
        if (member == null && event == JsonParser.Event.START_OBJECT && !this.objectMembers.isEmpty()) {
            String field;
            JsonObject object = parser.getObject();
            Iterator iterator = object.keySet().iterator();
            while (iterator.hasNext() && (member = this.objectMembers.get(field = (String)iterator.next())) == null) {
            }
            if (member == null) {
                member = this.fallbackObjectMember;
            }
            if (member != null) {
                parser = JsonpUtils.objectParser(object, mapper);
                event = parser.next();
            }
        }
        if (member == null) {
            throw new JsonParsingException("Cannot determine what union member to deserialize", parser.getLocation());
        }
        return member.deserialize(parser, mapper, event, this.buildFn);
    }

    public static class Builder<Union, Kind, Member>
    implements ObjectBuilder<JsonpDeserializer<Union>> {
        private final BiFunction<Kind, Member, Union> buildFn;
        private final List<SingleMemberHandler<Union, Kind, Member>> objectMembers = new ArrayList<SingleMemberHandler<Union, Kind, Member>>();
        private final Map<JsonParser.Event, EventHandler<Union, Kind, Member>> otherMembers = new HashMap<JsonParser.Event, EventHandler<Union, Kind, Member>>();
        private final boolean allowAmbiguousPrimitive;

        public Builder(BiFunction<Kind, Member, Union> buildFn, boolean allowAmbiguities) {
            this.allowAmbiguousPrimitive = allowAmbiguities;
            this.buildFn = buildFn;
        }

        private void addAmbiguousDeserializer(JsonParser.Event e, Kind tag, JsonpDeserializer<? extends Member> deserializer) {
            MultiMemberHandler mmh;
            EventHandler<Union, Kind, Member> m = this.otherMembers.get(e);
            if (m instanceof MultiMemberHandler) {
                mmh = (MultiMemberHandler)m;
            } else {
                mmh = new MultiMemberHandler();
                mmh.handlers = new ArrayList(2);
                mmh.handlers.add((SingleMemberHandler)m);
                this.otherMembers.put(e, mmh);
            }
            mmh.handlers.add(new SingleMemberHandler(tag, deserializer));
            mmh.handlers.sort(Comparator.comparingInt(a -> a.deserializer.acceptedEvents().size()));
        }

        private void addMember(JsonParser.Event e, Kind tag, SingleMemberHandler<Union, Kind, Member> member) {
            if (this.otherMembers.containsKey(e)) {
                if (!this.allowAmbiguousPrimitive || e == JsonParser.Event.START_OBJECT || e == JsonParser.Event.START_ARRAY) {
                    throw new AmbiguousUnionException("Union member '" + tag + "' conflicts with other members");
                }
                this.addAmbiguousDeserializer(e, tag, member.deserializer);
            } else {
                this.otherMembers.put(e, member);
            }
        }

        public Builder<Union, Kind, Member> addMember(Kind tag, JsonpDeserializer<? extends Member> deserializer) {
            JsonpDeserializer<? extends Member> unwrapped = DelegatingDeserializer.unwrap(deserializer);
            if (unwrapped instanceof ObjectDeserializer) {
                ObjectDeserializer od = (ObjectDeserializer)unwrapped;
                Set<String> allFields = od.fieldNames();
                HashSet<String> fields = new HashSet<String>(allFields);
                for (SingleMemberHandler<Union, Kind, Member> member : this.objectMembers) {
                    fields.removeAll(member.fields);
                    member.fields.removeAll(allFields);
                }
                SingleMemberHandler member = new SingleMemberHandler(tag, deserializer, fields);
                this.objectMembers.add(member);
                if (od.shortcutProperty() != null) {
                    this.addMember(JsonParser.Event.VALUE_STRING, tag, member);
                }
            } else {
                SingleMemberHandler member = new SingleMemberHandler(tag, deserializer);
                for (JsonParser.Event e : deserializer.nativeEvents()) {
                    this.addMember(e, tag, member);
                }
            }
            return this;
        }

        @Override
        public JsonpDeserializer<Union> build() {
            for (SingleMemberHandler<Union, Kind, Member> member : this.objectMembers) {
                if (!member.fields.isEmpty()) continue;
                throw new AmbiguousUnionException("All properties of '" + member.tag + "' also exist in other object members");
            }
            if (this.objectMembers.size() == 1 && !this.otherMembers.containsKey(JsonParser.Event.START_OBJECT)) {
                this.otherMembers.put(JsonParser.Event.START_OBJECT, this.objectMembers.remove(0));
            }
            return new UnionDeserializer<Union, Kind, Member>(this.objectMembers, this.otherMembers, this.buildFn);
        }
    }

    private static class MultiMemberHandler<Union, Kind, Member>
    extends EventHandler<Union, Kind, Member> {
        private List<SingleMemberHandler<Union, Kind, Member>> handlers;

        private MultiMemberHandler() {
        }

        @Override
        EnumSet<JsonParser.Event> nativeEvents() {
            EnumSet<JsonParser.Event> result = EnumSet.noneOf(JsonParser.Event.class);
            for (SingleMemberHandler<Union, Kind, Member> smh : this.handlers) {
                result.addAll(smh.deserializer.nativeEvents());
            }
            return result;
        }

        @Override
        Union deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event, BiFunction<Kind, Member, Union> buildFn) {
            RuntimeException exception = null;
            for (EventHandler eventHandler : this.handlers) {
                try {
                    return eventHandler.deserialize(parser, mapper, event, buildFn);
                }
                catch (RuntimeException ex) {
                    exception = ex;
                }
            }
            throw new JsonParsingException("Couldn't find a suitable union member deserializer", exception, parser.getLocation());
        }
    }

    private static class SingleMemberHandler<Union, Kind, Member>
    extends EventHandler<Union, Kind, Member> {
        private final JsonpDeserializer<? extends Member> deserializer;
        private final Kind tag;
        private final Set<String> fields;

        SingleMemberHandler(Kind tag, JsonpDeserializer<? extends Member> deserializer) {
            this(tag, deserializer, null);
        }

        SingleMemberHandler(Kind tag, JsonpDeserializer<? extends Member> deserializer, Set<String> fields) {
            this.deserializer = deserializer;
            this.tag = tag;
            this.fields = fields;
        }

        @Override
        EnumSet<JsonParser.Event> nativeEvents() {
            return this.deserializer.nativeEvents();
        }

        @Override
        Union deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event, BiFunction<Kind, Member, Union> buildFn) {
            return buildFn.apply(this.tag, this.deserializer.deserialize(parser, mapper, event));
        }
    }

    private static abstract class EventHandler<Union, Kind, Member> {
        private EventHandler() {
        }

        abstract Union deserialize(JsonParser var1, JsonpMapper var2, JsonParser.Event var3, BiFunction<Kind, Member, Union> var4);

        abstract EnumSet<JsonParser.Event> nativeEvents();
    }

    public static class AmbiguousUnionException
    extends RuntimeException {
        public AmbiguousUnionException(String message) {
            super(message);
        }
    }
}

