/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import jakarta.mail.MessagingException;
import java.util.Optional;
import org.apache.james.queue.api.MailPrioritySupport;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class WithPriority
extends GenericMailet {
    private Attribute priority;

    public String getMailetInfo() {
        return "With Priority Mailet";
    }

    public void init() throws MessagingException {
        Integer priorityRaw = Optional.ofNullable(this.getInitParameter("priority", null)).map(Integer::valueOf).orElseThrow(() -> new IllegalArgumentException("'priority' init parameter is compulsory"));
        if (priorityRaw < -9 || priorityRaw > 9) {
            throw new IllegalArgumentException("Invalid priority: Priority should be from -9 to 9");
        }
        this.priority = new Attribute(MailPrioritySupport.MAIL_PRIORITY, AttributeValue.of((Integer)priorityRaw));
    }

    public void service(Mail mail) throws MessagingException {
        mail.setAttribute(this.priority);
    }
}

