/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.commons.shaded.johnzon.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;
import org.apache.activemq.artemis.commons.shaded.johnzon.core.BufferStrategy;
import org.apache.activemq.artemis.commons.shaded.johnzon.core.JsonChars;
import org.apache.activemq.artemis.commons.shaded.johnzon.core.JsonLocationImpl;
import org.apache.activemq.artemis.commons.shaded.johnzon.core.RFC4627AwareInputStreamReader;
import org.apache.activemq.artemis.commons.shaded.johnzon.core.Strings;
import org.apache.activemq.artemis.commons.shaded.json.JsonException;
import org.apache.activemq.artemis.commons.shaded.json.stream.JsonLocation;
import org.apache.activemq.artemis.commons.shaded.json.stream.JsonParser;
import org.apache.activemq.artemis.commons.shaded.json.stream.JsonParsingException;

public class JsonStreamParserImpl
implements JsonChars,
JsonParser {
    private final char[] buffer;
    private int bufferPos = Integer.MIN_VALUE;
    private int availableCharsInBuffer;
    private int startOfValueInBuffer = -1;
    private int endOfValueInBuffer = -1;
    private final Reader in;
    private final BufferStrategy.BufferProvider<char[]> bufferProvider;
    private final BufferStrategy.BufferProvider<char[]> valueProvider;
    private final int maxValueLength;
    private byte previousEvent;
    private final char[] fallBackCopyBuffer;
    private int fallBackCopyBufferLength;
    private long currentLine = 1L;
    private long lastLineBreakPosition;
    private long pastBufferReadCount;
    private boolean isCurrentNumberIntegral = true;
    private int currentIntegralNumber = Integer.MIN_VALUE;
    private StructureElement currentStructureElement = null;

    public JsonStreamParserImpl(InputStream inputStream, int maxStringLength, BufferStrategy.BufferProvider<char[]> bufferProvider, BufferStrategy.BufferProvider<char[]> valueBuffer) {
        this(inputStream, null, null, maxStringLength, bufferProvider, valueBuffer);
    }

    public JsonStreamParserImpl(InputStream inputStream, Charset encoding, int maxStringLength, BufferStrategy.BufferProvider<char[]> bufferProvider, BufferStrategy.BufferProvider<char[]> valueBuffer) {
        this(inputStream, null, encoding, maxStringLength, bufferProvider, valueBuffer);
    }

    public JsonStreamParserImpl(Reader reader, int maxStringLength, BufferStrategy.BufferProvider<char[]> bufferProvider, BufferStrategy.BufferProvider<char[]> valueBuffer) {
        this(null, reader, null, maxStringLength, bufferProvider, valueBuffer);
    }

    private JsonStreamParserImpl(InputStream inputStream, Reader reader, Charset encoding, int maxStringLength, BufferStrategy.BufferProvider<char[]> bufferProvider, BufferStrategy.BufferProvider<char[]> valueBuffer) {
        this.maxValueLength = maxStringLength <= 0 ? 8192 : maxStringLength;
        this.fallBackCopyBuffer = valueBuffer.newBuffer();
        this.buffer = bufferProvider.newBuffer();
        this.bufferProvider = bufferProvider;
        this.valueProvider = valueBuffer;
        if (this.fallBackCopyBuffer.length < maxStringLength) {
            throw this.cust("Size of value buffer cannot be smaller than maximum string length");
        }
        this.in = reader != null ? reader : (encoding == null ? new RFC4627AwareInputStreamReader(inputStream) : new InputStreamReader(inputStream, encoding.newDecoder()));
    }

    private void appendToCopyBuffer(char c) {
        this.fallBackCopyBuffer[this.fallBackCopyBufferLength++] = c;
    }

    private void copyCurrentValue() {
        if (this.endOfValueInBuffer - this.startOfValueInBuffer > 0) {
            if (this.endOfValueInBuffer - this.startOfValueInBuffer > this.maxValueLength) {
                throw this.tmc();
            }
            System.arraycopy(this.buffer, this.startOfValueInBuffer, this.fallBackCopyBuffer, this.fallBackCopyBufferLength, this.endOfValueInBuffer - this.startOfValueInBuffer);
            this.fallBackCopyBufferLength += this.endOfValueInBuffer - this.startOfValueInBuffer;
        }
        this.endOfValueInBuffer = -1;
        this.startOfValueInBuffer = -1;
    }

    @Override
    public final boolean hasNext() {
        if (this.currentStructureElement != null || this.previousEvent != END_ARRAY && this.previousEvent != END_OBJECT && this.previousEvent != VALUE_STRING && this.previousEvent != VALUE_FALSE && this.previousEvent != VALUE_TRUE && this.previousEvent != VALUE_NULL && this.previousEvent != VALUE_NUMBER || this.previousEvent == 0) {
            return true;
        }
        if (this.bufferPos < this.availableCharsInBuffer) {
            char c = this.readNextNonWhitespaceChar(this.readNextChar());
            if (c == '\u0000') {
                return false;
            }
            if (this.bufferPos < this.availableCharsInBuffer) {
                throw this.uexc("EOF expected");
            }
        }
        return false;
    }

    private static boolean isAsciiDigit(char value) {
        return value <= '9' && value >= '0';
    }

    private int parseHexDigit(char value) {
        if (JsonStreamParserImpl.isAsciiDigit(value)) {
            return value - 48;
        }
        if (value <= 'f' && value >= 'a') {
            return value - 87;
        }
        if (value <= 'F' && value >= 'A') {
            return value - 55;
        }
        throw this.uexc("Invalid hex character");
    }

    private JsonLocation createLocation() {
        long column = 1L;
        long charOffset = 0L;
        if (this.bufferPos >= -1) {
            charOffset = this.pastBufferReadCount + (long)this.bufferPos + 1L;
            column = this.lastLineBreakPosition == 0L ? charOffset + 1L : charOffset - this.lastLineBreakPosition;
        }
        return new JsonLocationImpl(this.currentLine, column, charOffset);
    }

    protected final char readNextChar() {
        if (this.availableCharsInBuffer - this.bufferPos <= 1) {
            if (this.startOfValueInBuffer > -1 && this.endOfValueInBuffer == -1) {
                this.endOfValueInBuffer = this.availableCharsInBuffer;
                this.copyCurrentValue();
                this.startOfValueInBuffer = 0;
            }
            if (this.bufferPos >= -1) {
                this.pastBufferReadCount += (long)this.availableCharsInBuffer;
            }
            try {
                this.availableCharsInBuffer = this.in.read(this.buffer, 0, this.buffer.length);
                if (this.availableCharsInBuffer <= 0) {
                    return '\u0000';
                }
            }
            catch (IOException e) {
                this.close();
                throw this.uexio(e);
            }
            this.bufferPos = 0;
        } else {
            ++this.bufferPos;
        }
        return this.buffer[this.bufferPos];
    }

    protected final char readNextNonWhitespaceChar(char c) {
        int dosCount = 0;
        while (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
            if (c == '\n') {
                ++this.currentLine;
                this.lastLineBreakPosition = this.pastBufferReadCount + (long)this.bufferPos;
            }
            if (dosCount >= this.maxValueLength) {
                throw this.tmc();
            }
            ++dosCount;
            c = this.readNextChar();
        }
        return c;
    }

    @Override
    public final JsonParser.Event next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.previousEvent != 0 && this.currentStructureElement == null) {
            throw this.uexc("Unexpected end of structure");
        }
        char c = this.readNextNonWhitespaceChar(this.readNextChar());
        if (c == ',') {
            if (this.previousEvent == -128 || this.previousEvent == START_ARRAY || this.previousEvent == START_OBJECT || this.previousEvent == 127 || this.previousEvent == KEY_NAME) {
                throw this.uexc("Expected \" ] } LITERAL");
            }
            this.previousEvent = (byte)127;
            return this.next();
        }
        if (c == ':') {
            if (this.previousEvent != KEY_NAME) {
                throw this.uexc("A : can only follow a key name");
            }
            this.previousEvent = (byte)-128;
            return this.next();
        }
        if (!this.isCurrentNumberIntegral) {
            this.isCurrentNumberIntegral = true;
        }
        if (this.currentIntegralNumber != Integer.MIN_VALUE) {
            this.currentIntegralNumber = Integer.MIN_VALUE;
        }
        if (this.fallBackCopyBufferLength != 0) {
            this.fallBackCopyBufferLength = 0;
        }
        this.endOfValueInBuffer = -1;
        this.startOfValueInBuffer = -1;
        switch (c) {
            case '{': {
                return this.handleStartObject();
            }
            case '}': {
                return this.handleEndObject();
            }
            case '[': {
                return this.handleStartArray();
            }
            case ']': {
                return this.handleEndArray();
            }
            case '\"': {
                return this.handleQuote();
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'f': 
            case 'n': 
            case 't': {
                return this.handleLiteral();
            }
        }
        return this.defaultHandling(c);
    }

    protected JsonParser.Event defaultHandling(char c) {
        if (c == '\u0000') {
            throw this.uexc("End of file hit too early");
        }
        throw this.uexc("Expected structural character or digit or 't' or 'n' or 'f' or '-'");
    }

    private JsonParser.Event handleStartObject() {
        if (this.previousEvent != 0 && this.previousEvent != -128 && this.previousEvent != START_ARRAY && this.previousEvent != 127) {
            throw this.uexc("Expected : , [");
        }
        if (this.currentStructureElement == null) {
            this.currentStructureElement = new StructureElement(null, false);
        } else {
            StructureElement localStructureElement;
            if (!this.currentStructureElement.isArray && this.previousEvent != -128) {
                throw this.uexc("Expected :");
            }
            this.currentStructureElement = localStructureElement = new StructureElement(this.currentStructureElement, false);
        }
        this.previousEvent = START_OBJECT;
        return EVT_MAP[this.previousEvent];
    }

    private JsonParser.Event handleEndObject() {
        if (this.previousEvent == START_ARRAY || this.previousEvent == 127 || this.previousEvent == KEY_NAME || this.previousEvent == -128 || this.currentStructureElement == null) {
            throw this.uexc("Expected \" ] { } LITERAL");
        }
        if (this.currentStructureElement.isArray) {
            throw this.uexc("Expected : ]");
        }
        this.currentStructureElement = this.currentStructureElement.previous;
        this.previousEvent = END_OBJECT;
        return EVT_MAP[this.previousEvent];
    }

    private JsonParser.Event handleStartArray() {
        if (this.previousEvent != 0 && this.previousEvent != -128 && this.previousEvent != START_ARRAY && this.previousEvent != 127) {
            throw this.uexc("Expected : , [");
        }
        if (this.currentStructureElement == null) {
            this.currentStructureElement = new StructureElement(null, true);
        } else {
            StructureElement localStructureElement;
            if (!this.currentStructureElement.isArray && this.previousEvent != -128) {
                throw this.uexc("Expected \"");
            }
            this.currentStructureElement = localStructureElement = new StructureElement(this.currentStructureElement, true);
        }
        this.previousEvent = START_ARRAY;
        return EVT_MAP[this.previousEvent];
    }

    private JsonParser.Event handleEndArray() {
        if (this.previousEvent == START_OBJECT || this.previousEvent == 127 || this.previousEvent == -128 || this.currentStructureElement == null) {
            throw this.uexc("Expected [ ] } \" LITERAL");
        }
        if (!this.currentStructureElement.isArray) {
            throw this.uexc("Expected : }");
        }
        this.currentStructureElement = this.currentStructureElement.previous;
        this.previousEvent = END_ARRAY;
        return EVT_MAP[this.previousEvent];
    }

    private void readString() {
        while (true) {
            char n;
            if ((n = this.readNextChar()) == '\"') {
                this.endOfValueInBuffer = this.startOfValueInBuffer = this.bufferPos;
                return;
            }
            if (n == '\n') {
                throw this.uexc("Unexpected linebreak");
            }
            if (n <= '\u001f') {
                throw this.uexc("Unescaped control character");
            }
            if (n == '\\') {
                n = this.readNextChar();
                if (n == 'u') {
                    n = this.parseUnicodeHexChars();
                    this.appendToCopyBuffer(n);
                    continue;
                }
                if (n == '\\') {
                    this.appendToCopyBuffer(n);
                    continue;
                }
                this.appendToCopyBuffer(Strings.asEscapedChar(n));
                continue;
            }
            this.startOfValueInBuffer = this.bufferPos;
            this.endOfValueInBuffer = -1;
            while ((n = this.readNextChar()) > '\u001f' && n != '\\' && n != '\n' && n != '\"') {
            }
            this.endOfValueInBuffer = this.bufferPos;
            if (n == '\"') {
                if (this.fallBackCopyBufferLength > 0) {
                    this.copyCurrentValue();
                } else if (this.endOfValueInBuffer - this.startOfValueInBuffer > this.maxValueLength) {
                    throw this.tmc();
                }
                return;
            }
            if (n == '\n') {
                throw this.uexc("Unexpected linebreak");
            }
            if (n >= '\u0000' && n <= '\u001f') {
                throw this.uexc("Unescaped control character");
            }
            this.copyCurrentValue();
            --this.bufferPos;
        }
    }

    private char parseUnicodeHexChars() {
        return (char)(this.parseHexDigit(this.readNextChar()) * 4096 + this.parseHexDigit(this.readNextChar()) * 256 + this.parseHexDigit(this.readNextChar()) * 16 + this.parseHexDigit(this.readNextChar()));
    }

    private JsonParser.Event handleQuote() {
        if (this.previousEvent != -128 && this.previousEvent != START_OBJECT && this.previousEvent != START_ARRAY && this.previousEvent != 127) {
            throw this.uexc("Expected : { [ ,");
        }
        this.readString();
        if (this.previousEvent == -128) {
            if (this.currentStructureElement != null && this.currentStructureElement.isArray) {
                throw this.uexc("Key value pair not allowed in an array");
            }
            this.previousEvent = VALUE_STRING;
            return EVT_MAP[this.previousEvent];
        }
        if (this.currentStructureElement != null && this.currentStructureElement.isArray || this.currentStructureElement == null) {
            this.previousEvent = VALUE_STRING;
            return EVT_MAP[this.previousEvent];
        }
        this.previousEvent = KEY_NAME;
        return EVT_MAP[this.previousEvent];
    }

    private void readNumber() {
        char c = this.buffer[this.bufferPos];
        this.startOfValueInBuffer = this.bufferPos;
        this.endOfValueInBuffer = -1;
        char y = '\u0000';
        int cumulatedDigitValue = 0;
        while (JsonStreamParserImpl.isAsciiDigit(y = this.readNextChar())) {
            if (c == '0') {
                throw this.uexc("Leading zeros not allowed");
            }
            if (c == '-' && cumulatedDigitValue == 48) {
                throw this.uexc("Leading zeros after minus not allowed");
            }
            cumulatedDigitValue += y;
        }
        if (c == '-' && cumulatedDigitValue == 0) {
            throw this.uexc("Unexpected premature end of number");
        }
        if (y == '.') {
            this.isCurrentNumberIntegral = false;
            cumulatedDigitValue = 0;
            while (JsonStreamParserImpl.isAsciiDigit(y = this.readNextChar())) {
                ++cumulatedDigitValue;
            }
            if (cumulatedDigitValue == 0) {
                throw this.uexc("Unexpected premature end of number");
            }
        }
        if (y == 'e' || y == 'E') {
            this.isCurrentNumberIntegral = false;
            y = this.readNextChar();
            if (!JsonStreamParserImpl.isAsciiDigit(y) && y != '-' && y != '+') {
                throw this.uexc("Expected DIGIT or + or -");
            }
            if (!(y != '-' && y != '+' || JsonStreamParserImpl.isAsciiDigit(y = this.readNextChar()))) {
                throw this.uexc("Unexpected premature end of number");
            }
            while (JsonStreamParserImpl.isAsciiDigit(y = this.readNextChar())) {
            }
        }
        int n = this.endOfValueInBuffer = y == '\u0000' && this.endOfValueInBuffer < 0 ? -1 : this.bufferPos;
        if (y == ',' || y == ']' || y == '}' || y == '\n' || y == ' ' || y == '\t' || y == '\r' || y == '\u0000') {
            --this.bufferPos;
            if (this.isCurrentNumberIntegral && c == '-' && cumulatedDigitValue >= 48 && cumulatedDigitValue <= 57) {
                this.currentIntegralNumber = -(cumulatedDigitValue - 48);
                return;
            }
            if (this.isCurrentNumberIntegral && c != '-' && cumulatedDigitValue == 0) {
                this.currentIntegralNumber = c - 48;
                return;
            }
            if (this.fallBackCopyBufferLength > 0) {
                this.copyCurrentValue();
            } else if (this.endOfValueInBuffer - this.startOfValueInBuffer >= this.maxValueLength) {
                throw this.tmc();
            }
            return;
        }
        throw this.uexc("Unexpected premature end of number");
    }

    private JsonParser.Event handleLiteral() {
        if (this.previousEvent != -128 && this.previousEvent != START_ARRAY && this.previousEvent != 127) {
            throw this.uexc("Expected : , [");
        }
        if (this.previousEvent == 127 && !this.currentStructureElement.isArray) {
            throw this.uexc("Not in an array context");
        }
        char c = this.buffer[this.bufferPos];
        switch (c) {
            case 't': {
                if (this.readNextChar() != 'r' || this.readNextChar() != 'u' || this.readNextChar() != 'e') {
                    throw this.uexc("Expected LITERAL: true");
                }
                this.previousEvent = VALUE_TRUE;
                return EVT_MAP[this.previousEvent];
            }
            case 'f': {
                if (this.readNextChar() != 'a' || this.readNextChar() != 'l' || this.readNextChar() != 's' || this.readNextChar() != 'e') {
                    throw this.uexc("Expected LITERAL: false");
                }
                this.previousEvent = VALUE_FALSE;
                return EVT_MAP[this.previousEvent];
            }
            case 'n': {
                if (this.readNextChar() != 'u' || this.readNextChar() != 'l' || this.readNextChar() != 'l') {
                    throw this.uexc("Expected LITERAL: null");
                }
                this.previousEvent = VALUE_NULL;
                return EVT_MAP[this.previousEvent];
            }
        }
        this.readNumber();
        this.previousEvent = VALUE_NUMBER;
        return EVT_MAP[this.previousEvent];
    }

    @Override
    public String getString() {
        if (this.previousEvent == KEY_NAME || this.previousEvent == VALUE_STRING || this.previousEvent == VALUE_NUMBER) {
            return this.fallBackCopyBufferLength > 0 ? new String(this.fallBackCopyBuffer, 0, this.fallBackCopyBufferLength) : new String(this.buffer, this.startOfValueInBuffer, this.endOfValueInBuffer - this.startOfValueInBuffer);
        }
        throw new IllegalStateException((Object)((Object)EVT_MAP[this.previousEvent]) + " doesn't support getString()");
    }

    @Override
    public boolean isIntegralNumber() {
        if (this.previousEvent != VALUE_NUMBER) {
            throw new IllegalStateException((Object)((Object)EVT_MAP[this.previousEvent]) + " doesn't support isIntegralNumber()");
        }
        return this.isCurrentNumberIntegral;
    }

    @Override
    public int getInt() {
        if (this.previousEvent != VALUE_NUMBER) {
            throw new IllegalStateException((Object)((Object)EVT_MAP[this.previousEvent]) + " doesn't support getInt()");
        }
        if (this.isCurrentNumberIntegral && this.currentIntegralNumber != Integer.MIN_VALUE) {
            return this.currentIntegralNumber;
        }
        if (this.isCurrentNumberIntegral) {
            Integer retVal;
            Integer n = retVal = this.fallBackCopyBufferLength > 0 ? JsonStreamParserImpl.parseIntegerFromChars(this.fallBackCopyBuffer, 0, this.fallBackCopyBufferLength) : JsonStreamParserImpl.parseIntegerFromChars(this.buffer, this.startOfValueInBuffer, this.endOfValueInBuffer);
            if (retVal == null) {
                return this.getBigDecimal().intValue();
            }
            return retVal;
        }
        return this.getBigDecimal().intValue();
    }

    @Override
    public long getLong() {
        if (this.previousEvent != VALUE_NUMBER) {
            throw new IllegalStateException((Object)((Object)EVT_MAP[this.previousEvent]) + " doesn't support getLong()");
        }
        if (this.isCurrentNumberIntegral && this.currentIntegralNumber != Integer.MIN_VALUE) {
            return this.currentIntegralNumber;
        }
        if (this.isCurrentNumberIntegral) {
            Long retVal;
            Long l = retVal = this.fallBackCopyBufferLength > 0 ? JsonStreamParserImpl.parseLongFromChars(this.fallBackCopyBuffer, 0, this.fallBackCopyBufferLength) : JsonStreamParserImpl.parseLongFromChars(this.buffer, this.startOfValueInBuffer, this.endOfValueInBuffer);
            if (retVal == null) {
                return this.getBigDecimal().longValue();
            }
            return retVal;
        }
        return this.getBigDecimal().longValue();
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (this.previousEvent != VALUE_NUMBER) {
            throw new IllegalStateException((Object)((Object)EVT_MAP[this.previousEvent]) + " doesn't support getBigDecimal()");
        }
        if (this.isCurrentNumberIntegral && this.currentIntegralNumber != Integer.MIN_VALUE) {
            return new BigDecimal(this.currentIntegralNumber);
        }
        if (this.isCurrentNumberIntegral) {
            Long retVal;
            Long l = retVal = this.fallBackCopyBufferLength > 0 ? JsonStreamParserImpl.parseLongFromChars(this.fallBackCopyBuffer, 0, this.fallBackCopyBufferLength) : JsonStreamParserImpl.parseLongFromChars(this.buffer, this.startOfValueInBuffer, this.endOfValueInBuffer);
            if (retVal == null) {
                return this.fallBackCopyBufferLength > 0 ? new BigDecimal(this.fallBackCopyBuffer, 0, this.fallBackCopyBufferLength) : new BigDecimal(this.buffer, this.startOfValueInBuffer, this.endOfValueInBuffer - this.startOfValueInBuffer);
            }
            return new BigDecimal(retVal);
        }
        return this.fallBackCopyBufferLength > 0 ? new BigDecimal(this.fallBackCopyBuffer, 0, this.fallBackCopyBufferLength) : new BigDecimal(this.buffer, this.startOfValueInBuffer, this.endOfValueInBuffer - this.startOfValueInBuffer);
    }

    @Override
    public JsonLocation getLocation() {
        return this.createLocation();
    }

    @Override
    public void close() {
        this.bufferProvider.release(this.buffer);
        this.valueProvider.release(this.fallBackCopyBuffer);
        try {
            this.in.close();
        }
        catch (IOException e) {
            throw new JsonException("Unexpected IO exception " + e.getMessage(), e);
        }
    }

    private static Long parseLongFromChars(char[] chars, int start, int end) {
        int i;
        long retVal = 0L;
        boolean negative = chars[start] == '-';
        int n = i = negative ? start + 1 : start;
        while (i < end) {
            long tmp = retVal * 10L + (long)(chars[i] - 48);
            if (tmp < retVal) {
                return null;
            }
            retVal = tmp;
            ++i;
        }
        return negative ? -retVal : retVal;
    }

    private static Integer parseIntegerFromChars(char[] chars, int start, int end) {
        int i;
        int retVal = 0;
        boolean negative = chars[start] == '-';
        int n = i = negative ? start + 1 : start;
        while (i < end) {
            int tmp = retVal * 10 + (chars[i] - 48);
            if (tmp < retVal) {
                return null;
            }
            retVal = tmp;
            ++i;
        }
        return negative ? -retVal : retVal;
    }

    private JsonParsingException uexc(char c, String message) {
        JsonLocation location = this.createLocation();
        return new JsonParsingException("Unexpected character '" + c + "' (Codepoint: " + String.valueOf(c).codePointAt(0) + ") on " + location + ". Reason is [[" + message + "]]", location);
    }

    private JsonParsingException uexc(String message) {
        char c = this.bufferPos < 0 ? (char)'\u0000' : this.buffer[this.bufferPos];
        return this.uexc(c, message);
    }

    private JsonParsingException tmc() {
        JsonLocation location = this.createLocation();
        return new JsonParsingException("Too many characters. Maximum string/number length of " + this.maxValueLength + " exceeded on " + location + ". Maybe increase org.apache.johnzon.max-string-length in jsonp factory properties or system properties.", location);
    }

    private JsonParsingException uexio(IOException e) {
        JsonLocation location = this.createLocation();
        return new JsonParsingException("Unexpected IO exception on " + location, e, location);
    }

    private JsonParsingException cust(String message) {
        JsonLocation location = this.createLocation();
        return new JsonParsingException("General exception on " + location + ". Reason is [[" + message + "]]", location);
    }

    private static final class StructureElement {
        private final StructureElement previous;
        private final boolean isArray;

        StructureElement(StructureElement previous, boolean isArray) {
            this.previous = previous;
            this.isArray = isArray;
        }
    }
}

