/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collection;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetAuthorizationEntryResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String GET_AUTHORIZATION_ENTRY_RESPONSE_OID = "1.3.6.1.4.1.30221.2.5.6";
    private static final byte TYPE_IS_AUTHENTICATED = -128;
    private static final byte TYPE_IDENTITIES_MATCH = -127;
    private static final byte TYPE_AUTHN_ENTRY = -94;
    private static final byte TYPE_AUTHZ_ENTRY = -93;
    private static final byte TYPE_AUTHID = -128;
    private static final byte TYPE_AUTHDN = -127;
    private static final byte TYPE_ATTRIBUTES = -94;
    private static final long serialVersionUID = -5443107150740697226L;
    private final boolean identitiesMatch;
    private final boolean isAuthenticated;
    @Nullable
    private final ReadOnlyEntry authNEntry;
    @Nullable
    private final ReadOnlyEntry authZEntry;
    @Nullable
    private final String authNID;
    @Nullable
    private final String authZID;

    GetAuthorizationEntryResponseControl() {
        this.isAuthenticated = false;
        this.identitiesMatch = true;
        this.authNEntry = null;
        this.authNID = null;
        this.authZEntry = null;
        this.authZID = null;
    }

    public GetAuthorizationEntryResponseControl(boolean isAuthenticated, boolean identitiesMatch, @Nullable String authNID, @Nullable ReadOnlyEntry authNEntry, @Nullable String authZID, @Nullable ReadOnlyEntry authZEntry) {
        super(GET_AUTHORIZATION_ENTRY_RESPONSE_OID, false, GetAuthorizationEntryResponseControl.encodeValue(isAuthenticated, identitiesMatch, authNID, authNEntry, authZID, authZEntry));
        this.isAuthenticated = isAuthenticated;
        this.identitiesMatch = identitiesMatch;
        this.authNID = authNID;
        this.authNEntry = authNEntry;
        this.authZID = authZID;
        this.authZEntry = authZEntry;
    }

    public GetAuthorizationEntryResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_AUTHORIZATION_ENTRY_RESPONSE_NO_VALUE.get());
        }
        try {
            boolean isAuth = false;
            boolean idsMatch = false;
            String nID = null;
            String zID = null;
            ReadOnlyEntry nEntry = null;
            ReadOnlyEntry zEntry = null;
            ASN1Element valElement = ASN1Element.decode(value.getValue());
            block8: for (ASN1Element e : ASN1Sequence.decodeAsSequence(valElement).elements()) {
                switch (e.getType()) {
                    case -128: {
                        isAuth = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block8;
                    }
                    case -127: {
                        idsMatch = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block8;
                    }
                    case -94: {
                        Object[] nObjects = GetAuthorizationEntryResponseControl.decodeAuthEntry(e);
                        nID = (String)nObjects[0];
                        nEntry = (ReadOnlyEntry)nObjects[1];
                        continue block8;
                    }
                    case -93: {
                        Object[] zObjects = GetAuthorizationEntryResponseControl.decodeAuthEntry(e);
                        zID = (String)zObjects[0];
                        zEntry = (ReadOnlyEntry)zObjects[1];
                        continue block8;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_AUTHORIZATION_ENTRY_RESPONSE_INVALID_VALUE_TYPE.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
            this.isAuthenticated = isAuth;
            this.identitiesMatch = idsMatch;
            this.authNID = nID;
            this.authNEntry = nEntry;
            this.authZID = zID;
            this.authZEntry = zEntry;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_AUTHORIZATION_ENTRY_RESPONSE_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    @NotNull
    public GetAuthorizationEntryResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new GetAuthorizationEntryResponseControl(oid, isCritical, value);
    }

    @Nullable
    public static GetAuthorizationEntryResponseControl get(@NotNull BindResult result) throws LDAPException {
        Control c = result.getResponseControl(GET_AUTHORIZATION_ENTRY_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof GetAuthorizationEntryResponseControl) {
            return (GetAuthorizationEntryResponseControl)c;
        }
        return new GetAuthorizationEntryResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @NotNull
    private static ASN1OctetString encodeValue(boolean isAuthenticated, boolean identitiesMatch, @Nullable String authNID, @Nullable ReadOnlyEntry authNEntry, @Nullable String authZID, @Nullable ReadOnlyEntry authZEntry) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(4);
        elements.add(new ASN1Boolean(-128, isAuthenticated));
        elements.add(new ASN1Boolean(-127, identitiesMatch));
        if (authNEntry != null) {
            elements.add(GetAuthorizationEntryResponseControl.encodeAuthEntry((byte)-94, authNID, authNEntry));
        }
        if (authZEntry != null) {
            elements.add(GetAuthorizationEntryResponseControl.encodeAuthEntry((byte)-93, authZID, authZEntry));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @NotNull
    private static ASN1Sequence encodeAuthEntry(byte type, @Nullable String authID, @NotNull ReadOnlyEntry authEntry) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(3);
        if (authID != null) {
            elements.add(new ASN1OctetString(-128, authID));
        }
        elements.add(new ASN1OctetString(-127, authEntry.getDN()));
        Collection<Attribute> attributes = authEntry.getAttributes();
        ArrayList<ASN1Sequence> attrElements = new ArrayList<ASN1Sequence>(attributes.size());
        for (Attribute a : attributes) {
            attrElements.add(a.encode());
        }
        elements.add(new ASN1Sequence(-94, attrElements));
        return new ASN1Sequence(type, elements);
    }

    @NotNull
    private static Object[] decodeAuthEntry(@NotNull ASN1Element element) throws ASN1Exception, LDAPException {
        String authID = null;
        String authDN = null;
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(20);
        block5: for (ASN1Element e : ASN1Sequence.decodeAsSequence(element).elements()) {
            switch (e.getType()) {
                case -128: {
                    authID = ASN1OctetString.decodeAsOctetString(e).stringValue();
                    continue block5;
                }
                case -127: {
                    authDN = ASN1OctetString.decodeAsOctetString(e).stringValue();
                    continue block5;
                }
                case -94: {
                    for (ASN1Element ae : ASN1Sequence.decodeAsSequence(e).elements()) {
                        attrs.add(Attribute.decode(ASN1Sequence.decodeAsSequence(ae)));
                    }
                    continue block5;
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_AUTHORIZATION_ENTRY_RESPONSE_INVALID_ENTRY_TYPE.get(StaticUtils.toHex(e.getType())));
                }
            }
        }
        return new Object[]{authID, new ReadOnlyEntry(authDN, attrs)};
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public boolean identitiesMatch() {
        return this.identitiesMatch;
    }

    @Nullable
    public String getAuthNID() {
        if (this.authNID == null && this.identitiesMatch) {
            return this.authZID;
        }
        return this.authNID;
    }

    @Nullable
    public ReadOnlyEntry getAuthNEntry() {
        if (this.authNEntry == null && this.identitiesMatch) {
            return this.authZEntry;
        }
        return this.authNEntry;
    }

    @Nullable
    public String getAuthZID() {
        if (this.authZID == null && this.identitiesMatch) {
            return this.authNID;
        }
        return this.authZID;
    }

    @Nullable
    public ReadOnlyEntry getAuthZEntry() {
        if (this.authZEntry == null && this.identitiesMatch) {
            return this.authNEntry;
        }
        return this.authZEntry;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_GET_AUTHORIZATION_ENTRY_RESPONSE.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("GetAuthorizationEntryResponseControl(identitiesMatch=");
        buffer.append(this.identitiesMatch);
        if (this.authNID != null) {
            buffer.append(", authNID='");
            buffer.append(this.authNID);
            buffer.append('\'');
        }
        if (this.authNEntry != null) {
            buffer.append(", authNEntry=");
            this.authNEntry.toString(buffer);
        }
        if (this.authZID != null) {
            buffer.append(", authZID='");
            buffer.append(this.authZID);
            buffer.append('\'');
        }
        if (this.authZEntry != null) {
            buffer.append(", authZEntry=");
            this.authZEntry.toString(buffer);
        }
        buffer.append(')');
    }
}

