/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.usage;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.rest.BaseRestHandler;

public class UsageService {
    private final Map<String, BaseRestHandler> handlers = new HashMap<String, BaseRestHandler>();

    public void addRestHandler(BaseRestHandler handler) {
        Objects.requireNonNull(handler);
        if (handler.getName() == null) {
            throw new IllegalArgumentException("handler of type [" + handler.getClass().getName() + "] does not have a name");
        }
        BaseRestHandler maybeHandler = this.handlers.put(handler.getName(), handler);
        if (maybeHandler != null && maybeHandler != handler) {
            String message = String.format(Locale.ROOT, "handler of type [%s] conflicts with handler of type [%s] as they both have the same name [%s]", handler.getClass().getName(), maybeHandler.getClass().getName(), handler.getName());
            throw new IllegalArgumentException(message);
        }
    }

    public Map<String, Long> getRestUsageStats() {
        HashMap<String, Long> restUsageMap = new HashMap<String, Long>();
        this.handlers.values().forEach(handler -> {
            long usageCount = handler.getUsageCount();
            if (usageCount > 0L) {
                restUsageMap.put(handler.getName(), usageCount);
            }
        });
        return restUsageMap;
    }
}

