/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.lang.reflect.Method;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.unit.TimeValue;

public final class ScriptContext<FactoryType> {
    public final String name;
    public final Class<FactoryType> factoryClazz;
    public final Class<?> statefulFactoryClazz;
    public final Class<?> instanceClazz;
    public final int cacheSizeDefault;
    public final TimeValue cacheExpireDefault;
    public final Tuple<Integer, TimeValue> maxCompilationRateDefault;

    public ScriptContext(String name, Class<FactoryType> factoryClazz, int cacheSizeDefault, TimeValue cacheExpireDefault, Tuple<Integer, TimeValue> maxCompilationRateDefault) {
        this.name = name;
        this.factoryClazz = factoryClazz;
        Method newInstanceMethod = this.findMethod("FactoryType", factoryClazz, "newInstance");
        Method newFactoryMethod = this.findMethod("FactoryType", factoryClazz, "newFactory");
        if (newFactoryMethod != null) {
            assert (newInstanceMethod == null);
            this.statefulFactoryClazz = newFactoryMethod.getReturnType();
            newInstanceMethod = this.findMethod("StatefulFactoryType", this.statefulFactoryClazz, "newInstance");
            if (newInstanceMethod == null) {
                throw new IllegalArgumentException("Could not find method newInstance StatefulFactoryType class [" + this.statefulFactoryClazz.getName() + "] for script context [" + name + "]");
            }
        } else if (newInstanceMethod != null) {
            assert (newFactoryMethod == null);
            this.statefulFactoryClazz = null;
        } else {
            throw new IllegalArgumentException("Could not find method newInstance or method newFactory on FactoryType class [" + factoryClazz.getName() + "] for script context [" + name + "]");
        }
        this.instanceClazz = newInstanceMethod.getReturnType();
        this.cacheSizeDefault = cacheSizeDefault;
        this.cacheExpireDefault = cacheExpireDefault;
        this.maxCompilationRateDefault = maxCompilationRateDefault;
    }

    public ScriptContext(String name, Class<FactoryType> factoryClazz) {
        this(name, factoryClazz, 100, TimeValue.timeValueMillis((long)0L), (Tuple<Integer, TimeValue>)new Tuple((Object)75, (Object)TimeValue.timeValueMinutes((long)5L)));
    }

    private Method findMethod(String type, Class<?> clazz, String methodName) {
        Method foundMethod = null;
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            if (foundMethod != null) {
                throw new IllegalArgumentException("Cannot have multiple " + methodName + " methods on " + type + " class [" + clazz.getName() + "] for script context [" + this.name + "]");
            }
            foundMethod = method;
        }
        return foundMethod;
    }
}

