/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.beans.Transient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
@Immutable
class DefaultSdkHttpFullResponse
implements SdkHttpFullResponse,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String statusText;
    private final int statusCode;
    private final Map<String, List<String>> headers;
    private final transient AbortableInputStream content;

    private DefaultSdkHttpFullResponse(Builder builder) {
        this.statusCode = Validate.isNotNegative((int)builder.statusCode, (String)"Status code must not be negative.");
        this.statusText = builder.statusText;
        this.headers = builder.headersAreFromToBuilder ? builder.headers : CollectionUtils.deepUnmodifiableMap((Map)builder.headers, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER));
        this.content = builder.content;
    }

    @Override
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    @Override
    @Transient
    public Optional<AbortableInputStream> content() {
        return Optional.ofNullable(this.content);
    }

    @Override
    public Optional<String> statusText() {
        return Optional.ofNullable(this.statusText);
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public SdkHttpFullResponse.Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultSdkHttpFullResponse that = (DefaultSdkHttpFullResponse)o;
        return this.statusCode == that.statusCode && Objects.equals(this.statusText, that.statusText) && Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        int result = this.statusText != null ? this.statusText.hashCode() : 0;
        result = 31 * result + this.statusCode;
        result = 31 * result + Objects.hashCode(this.headers);
        return result;
    }

    static final class Builder
    implements SdkHttpFullResponse.Builder {
        private String statusText;
        private int statusCode;
        private AbortableInputStream content;
        private boolean headersAreFromToBuilder;
        private Map<String, List<String>> headers;

        Builder() {
            this.headersAreFromToBuilder = false;
            this.headers = new LinkedHashMap<String, List<String>>();
        }

        private Builder(DefaultSdkHttpFullResponse defaultSdkHttpFullResponse) {
            this.statusText = defaultSdkHttpFullResponse.statusText;
            this.statusCode = defaultSdkHttpFullResponse.statusCode;
            this.content = defaultSdkHttpFullResponse.content;
            this.headersAreFromToBuilder = true;
            this.headers = defaultSdkHttpFullResponse.headers;
        }

        @Override
        public String statusText() {
            return this.statusText;
        }

        @Override
        public Builder statusText(String statusText) {
            this.statusText = statusText;
            return this;
        }

        @Override
        public int statusCode() {
            return this.statusCode;
        }

        @Override
        public Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public AbortableInputStream content() {
            return this.content;
        }

        @Override
        public Builder content(AbortableInputStream content) {
            this.content = content;
            return this;
        }

        @Override
        public Builder putHeader(String headerName, List<String> headerValues) {
            Validate.paramNotNull((Object)headerName, (String)"headerName");
            Validate.paramNotNull(headerValues, (String)"headerValues");
            this.copyHeadersIfNeeded();
            this.headers.put(headerName, new ArrayList<String>(headerValues));
            return this;
        }

        @Override
        public SdkHttpFullResponse.Builder appendHeader(String headerName, String headerValue) {
            Validate.paramNotNull((Object)headerName, (String)"headerName");
            Validate.paramNotNull((Object)headerValue, (String)"headerValue");
            this.copyHeadersIfNeeded();
            this.headers.computeIfAbsent(headerName, k -> new ArrayList()).add(headerValue);
            return this;
        }

        @Override
        public Builder headers(Map<String, List<String>> headers) {
            Validate.paramNotNull(headers, (String)"headers");
            this.headers = CollectionUtils.deepCopyMap(headers);
            this.headersAreFromToBuilder = false;
            return this;
        }

        @Override
        public Builder removeHeader(String headerName) {
            this.copyHeadersIfNeeded();
            this.headers.remove(headerName);
            return this;
        }

        @Override
        public Builder clearHeaders() {
            this.headers = new LinkedHashMap<String, List<String>>();
            this.headersAreFromToBuilder = false;
            return this;
        }

        @Override
        public Map<String, List<String>> headers() {
            return CollectionUtils.unmodifiableMapOfLists(this.headers);
        }

        private void copyHeadersIfNeeded() {
            if (this.headersAreFromToBuilder) {
                this.headersAreFromToBuilder = false;
                this.headers = CollectionUtils.deepCopyMap(this.headers);
            }
        }

        @Override
        public SdkHttpFullResponse build() {
            return new DefaultSdkHttpFullResponse(this);
        }
    }
}

