/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.identity;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.CassandraTypesProvider;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.identity.CustomIdentityDAO;
import org.apache.james.jmap.api.identity.IdentityCreationRequest;
import org.apache.james.jmap.api.identity.IdentityNotFoundException;
import org.apache.james.jmap.api.identity.IdentityUpdate;
import org.apache.james.jmap.api.model.EmailAddress;
import org.apache.james.jmap.api.model.EmailerName;
import org.apache.james.jmap.api.model.Identity;
import org.apache.james.jmap.api.model.IdentityId;
import org.apache.james.jmap.api.model.IdentityId$;
import org.apache.james.jmap.cassandra.identity.CassandraCustomIdentityDAO$;
import org.apache.james.jmap.cassandra.identity.tables.CassandraCustomIdentityTable$;
import org.apache.james.jmap.cassandra.identity.tables.CassandraCustomIdentityTable$EmailAddress$;
import org.apache.james.jmap.cassandra.utils.EmailAddressTupleUtil;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.javaapi.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t\u0015h\u0001B\u00193\u0001~B\u0001\u0002\u0018\u0001\u0003\u0016\u0004%\t!\u0018\u0005\tU\u0002\u0011\t\u0012)A\u0005=\"A1\u000e\u0001BK\u0002\u0013\u0005A\u000e\u0003\u0005w\u0001\tE\t\u0015!\u0003n\u0011\u00159\b\u0001\"\u0001y\u0011%\ti\u0001\u0001b\u0001\n\u0003\ty\u0001\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\t\u0011%\ty\u0002\u0001b\u0001\n\u0003\t\t\u0003\u0003\u0005\u0002.\u0001\u0001\u000b\u0011BA\u0012\u0011%\ty\u0003\u0001b\u0001\n\u0003\t\t\u0004\u0003\u0005\u0002:\u0001\u0001\u000b\u0011BA\u001a\u0011%\tY\u0004\u0001b\u0001\n\u0003\t\t\u0004\u0003\u0005\u0002>\u0001\u0001\u000b\u0011BA\u001a\u0011%\ty\u0004\u0001b\u0001\n\u0003\t\t\u0004\u0003\u0005\u0002B\u0001\u0001\u000b\u0011BA\u001a\u0011%\t\u0019\u0005\u0001b\u0001\n\u0003\t\t\u0004\u0003\u0005\u0002F\u0001\u0001\u000b\u0011BA\u001a\u0011\u001d\t9\u0005\u0001C!\u0003\u0013Bq!a\u0012\u0001\t\u0003\n\u0019\tC\u0004\u0002\u0014\u0002!\t%!&\t\u000f\u0005}\u0005\u0001\"\u0011\u0002\"\"9\u0011q\u0015\u0001\u0005B\u0005%\u0006bBAa\u0001\u0011\u0005\u00131\u0019\u0005\b\u0003\u0017\u0004A\u0011IAg\u0011\u001d\ti\u000e\u0001C\u0005\u0003?Dq!!:\u0001\t\u0013\t9\u000fC\u0004\u0002t\u0002!I!!>\t\u000f\t-\u0001\u0001\"\u0003\u0003\u000e!9!\u0011\u0003\u0001\u0005\n\tM\u0001b\u0002B\u0018\u0001\u0011%!\u0011\u0007\u0005\n\u0005o\u0001\u0011\u0011!C\u0001\u0005sA\u0011Ba\u0010\u0001#\u0003%\tA!\u0011\t\u0013\t]\u0003!%A\u0005\u0002\te\u0003\"\u0003B/\u0001\u0005\u0005I\u0011\tB0\u0011%\u0011i\u0007AA\u0001\n\u0003\u0011y\u0007C\u0005\u0003x\u0001\t\t\u0011\"\u0001\u0003z!I!Q\u0011\u0001\u0002\u0002\u0013\u0005!q\u0011\u0005\n\u0005#\u0003\u0011\u0011!C!\u0005'C\u0011Ba&\u0001\u0003\u0003%\tE!'\t\u0013\tm\u0005!!A\u0005B\tu\u0005\"\u0003BP\u0001\u0005\u0005I\u0011\tBQ\u000f%\u0011)KMA\u0001\u0012\u0003\u00119K\u0002\u00052e\u0005\u0005\t\u0012\u0001BU\u0011\u001998\u0006\"\u0001\u0003B\"I!1T\u0016\u0002\u0002\u0013\u0015#Q\u0014\u0005\n\u0005\u0007\\\u0013\u0011!CA\u0005\u000bD\u0011Ba3,\u0003\u0003%\tI!4\t\u0013\tm7&!A\u0005\n\tu'AG\"bgN\fg\u000e\u001a:b\u0007V\u001cHo\\7JI\u0016tG/\u001b;z\t\u0006{%BA\u001a5\u0003!IG-\u001a8uSRL(BA\u001b7\u0003%\u0019\u0017m]:b]\u0012\u0014\u0018M\u0003\u00028q\u0005!!.\\1q\u0015\tI$(A\u0003kC6,7O\u0003\u0002<y\u00051\u0011\r]1dQ\u0016T\u0011!P\u0001\u0004_J<7\u0001A\n\u0006\u0001\u00013U\n\u0015\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0002\u0007\u0006)1oY1mC&\u0011QI\u0011\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u001d[U\"\u0001%\u000b\u0005MJ%B\u0001&7\u0003\r\t\u0007/[\u0005\u0003\u0019\"\u0013\u0011cQ;ti>l\u0017\nZ3oi&$\u0018\u0010R!P!\t\te*\u0003\u0002P\u0005\n9\u0001K]8ek\u000e$\bCA)Z\u001d\t\u0011vK\u0004\u0002T-6\tAK\u0003\u0002V}\u00051AH]8pizJ\u0011aQ\u0005\u00031\n\u000bq\u0001]1dW\u0006<W-\u0003\u0002[7\na1+\u001a:jC2L'0\u00192mK*\u0011\u0001LQ\u0001\bg\u0016\u001c8/[8o+\u0005q\u0006CA0i\u001b\u0005\u0001'BA1c\u0003\u0011\u0019wN]3\u000b\u0005\r$\u0017A\u00023sSZ,'O\u0003\u0002fM\u0006AA-\u0019;bgR\f\u0007PC\u0001h\u0003\r\u0019w.\\\u0005\u0003S\u0002\u0014qaU3tg&|g.\u0001\u0005tKN\u001c\u0018n\u001c8!\u00035!\u0018\u0010]3t!J|g/\u001b3feV\tQ\u000e\u0005\u0002oi6\tqN\u0003\u0002qc\u0006!\u0011N\\5u\u0015\t)$O\u0003\u0002tq\u0005A!-Y2lK:$7/\u0003\u0002v_\n12)Y:tC:$'/\u0019+za\u0016\u001c\bK]8wS\u0012,'/\u0001\busB,7\u000f\u0015:pm&$WM\u001d\u0011\u0002\rqJg.\u001b;?)\rI8\u0010 \t\u0003u\u0002i\u0011A\r\u0005\u00069\u0016\u0001\rA\u0018\u0005\u0006W\u0016\u0001\r!\u001c\u0015\u0003\u000by\u00042a`A\u0005\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011AB5oU\u0016\u001cGO\u0003\u0002\u0002\b\u0005)!.\u0019<bq&!\u00111BA\u0001\u0005\u0019IeN[3di\u0006AQ\r_3dkR|'/\u0006\u0002\u0002\u0012A!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u0018E\fQ!\u001e;jYNLA!a\u0007\u0002\u0016\t12)Y:tC:$'/Y!ts:\u001cW\t_3dkR|'/A\u0005fq\u0016\u001cW\u000f^8sA\u0005)R-\\1jY\u0006#GM]3tgR+\b\u000f\\3Vi&dWCAA\u0012!\u0011\t)#!\u000b\u000e\u0005\u0005\u001d\"bAA\fi%!\u00111FA\u0014\u0005U)U.Y5m\u0003\u0012$'/Z:t)V\u0004H.Z+uS2\fa#Z7bS2\fE\r\u001a:fgN$V\u000f\u001d7f+RLG\u000eI\u0001\u0010S:\u001cXM\u001d;Ti\u0006$X-\\3oiV\u0011\u00111\u0007\t\u0004?\u0006U\u0012bAA\u001cA\n\t\u0002K]3qCJ,Gm\u0015;bi\u0016lWM\u001c;\u0002!%t7/\u001a:u'R\fG/Z7f]R\u0004\u0013AE:fY\u0016\u001cG/\u00117m'R\fG/Z7f]R\f1c]3mK\u000e$\u0018\t\u001c7Ti\u0006$X-\\3oi\u0002\n!c]3mK\u000e$xJ\\3Ti\u0006$X-\\3oi\u0006\u00192/\u001a7fGR|e.Z*uCR,W.\u001a8uA\u0005\u0011B-\u001a7fi\u0016|e.Z*uCR,W.\u001a8u\u0003M!W\r\\3uK>sWm\u0015;bi\u0016lWM\u001c;!\u0003\u0011\u0019\u0018M^3\u0015\r\u0005-\u00131NA=!\u0019\ti%a\u0017\u0002`5\u0011\u0011q\n\u0006\u0005\u0003#\n\u0019&A\u0005qk\nd\u0017n\u001d5fe*\u00191)!\u0016\u000b\u0007\u0005\f9F\u0003\u0002\u0002Z\u00059!/Z1di>\u0014\u0018\u0002BA/\u0003\u001f\u0012QaU'p]>\u0004B!!\u0019\u0002h5\u0011\u00111\r\u0006\u0004\u0003KJ\u0015!B7pI\u0016d\u0017\u0002BA5\u0003G\u0012\u0001\"\u00133f]RLG/\u001f\u0005\b\u0003[\u0012\u0002\u0019AA8\u0003\u0011)8/\u001a:\u0011\t\u0005E\u0014QO\u0007\u0003\u0003gR!!\u0019\u001d\n\t\u0005]\u00141\u000f\u0002\t+N,'O\\1nK\"9\u00111\u0010\nA\u0002\u0005u\u0014aD2sK\u0006$\u0018n\u001c8SKF,Xm\u001d;\u0011\u0007\u001d\u000by(C\u0002\u0002\u0002\"\u0013q#\u00133f]RLG/_\"sK\u0006$\u0018n\u001c8SKF,Xm\u001d;\u0015\u0011\u0005-\u0013QQAD\u0003#Cq!!\u001c\u0014\u0001\u0004\ty\u0007C\u0004\u0002\nN\u0001\r!a#\u0002\u0015%$WM\u001c;jifLE\r\u0005\u0003\u0002b\u00055\u0015\u0002BAH\u0003G\u0012!\"\u00133f]RLG/_%e\u0011\u001d\tYh\u0005a\u0001\u0003{\nA\u0001\\5tiR!\u0011qSAO!\u0019\ti%!'\u0002`%!\u00111TA(\u0005\u0015\u0019f\t\\;y\u0011\u001d\ti\u0007\u0006a\u0001\u0003_\n\u0001CZ5oI\nK\u0018\nZ3oi&$\u00180\u00133\u0015\r\u0005-\u00131UAS\u0011\u001d\ti'\u0006a\u0001\u0003_Bq!!#\u0016\u0001\u0004\tY)\u0001\u0004va\u0012\fG/\u001a\u000b\t\u0003W\u000b\u0019,!.\u00028B1\u0011QJA.\u0003[\u00032!QAX\u0013\r\t\tL\u0011\u0002\u0005+:LG\u000fC\u0004\u0002nY\u0001\r!a\u001c\t\u000f\u0005%e\u00031\u0001\u0002\f\"9\u0011\u0011\u0018\fA\u0002\u0005m\u0016AD5eK:$\u0018\u000e^=Va\u0012\fG/\u001a\t\u0004\u000f\u0006u\u0016bAA`\u0011\nq\u0011\nZ3oi&$\u00180\u00169eCR,\u0017AB;qg\u0016\u0014H\u000f\u0006\u0004\u0002,\u0006\u0015\u0017q\u0019\u0005\b\u0003[:\u0002\u0019AA8\u0011\u001d\tIm\u0006a\u0001\u0003?\nQ\u0001]1uG\"\fa\u0001Z3mKR,GCBAV\u0003\u001f\f\u0019\u000eC\u0004\u0002Rb\u0001\r!a\u001c\u0002\u0011U\u001cXM\u001d8b[\u0016Dq!!6\u0019\u0001\u0004\t9.A\u0002jIN\u0004R!UAm\u0003\u0017K1!a7\\\u0005\r\u0019V-]\u0001\u0007S:\u001cXM\u001d;\u0015\r\u0005-\u0013\u0011]Ar\u0011\u001d\t\t.\u0007a\u0001\u0003_BaaM\rA\u0002\u0005}\u0013A\u0003;p\u0013\u0012,g\u000e^5usR!\u0011qLAu\u0011\u001d\tYO\u0007a\u0001\u0003[\f1A]8x!\ry\u0016q^\u0005\u0004\u0003c\u0004'a\u0001*po\u0006IAo\u001c*fa2LHk\u001c\u000b\u0005\u0003o\u0014I\u0001E\u0003B\u0003s\fi0C\u0002\u0002|\n\u0013aa\u00149uS>t\u0007#B)\u0002\u0000\n\r\u0011b\u0001B\u00017\n!A*[:u!\u0011\t\tG!\u0002\n\t\t\u001d\u00111\r\u0002\r\u000b6\f\u0017\u000e\\!eIJ,7o\u001d\u0005\b\u0003W\\\u0002\u0019AAw\u0003\u0015!xNQ2d)\u0011\t9Pa\u0004\t\u000f\u0005-H\u00041\u0001\u0002n\u0006IAo\u001c&bm\u0006\u001cV\r\u001e\u000b\u0005\u0005+\u0011Y\u0003\u0005\u0004\u0003\u0018\t\u0005\"QE\u0007\u0003\u00053QAAa\u0007\u0003\u001e\u0005!Q\u000f^5m\u0015\t\u0011y\"\u0001\u0003kCZ\f\u0017\u0002\u0002B\u0012\u00053\u00111aU3u!\ry&qE\u0005\u0004\u0005S\u0001'\u0001C+E)Z\u000bG.^3\t\u000f\t5R\u00041\u0001\u0002~\u0006\u0001B.[:u\u000b6\f\u0017\u000e\\!eIJ,7o]\u0001\u000fi>,U.Y5m\u0003\u0012$'/Z:t)\u0011\u0011\u0019Aa\r\t\u000f\tUb\u00041\u0001\u0003&\u0005AQ\u000f\u001a;WC2,X-\u0001\u0003d_BLH#B=\u0003<\tu\u0002b\u0002/ !\u0003\u0005\rA\u0018\u0005\bW~\u0001\n\u00111\u0001n\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa\u0011+\u0007y\u0013)e\u000b\u0002\u0003HA!!\u0011\nB*\u001b\t\u0011YE\u0003\u0003\u0003N\t=\u0013!C;oG\",7m[3e\u0015\r\u0011\tFQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B+\u0005\u0017\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"Aa\u0017+\u00075\u0014)%A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005C\u0002BAa\u0019\u0003j5\u0011!Q\r\u0006\u0005\u0005O\u0012i\"\u0001\u0003mC:<\u0017\u0002\u0002B6\u0005K\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B9!\r\t%1O\u0005\u0004\u0005k\u0012%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B>\u0005\u0003\u00032!\u0011B?\u0013\r\u0011yH\u0011\u0002\u0004\u0003:L\b\"\u0003BBI\u0005\u0005\t\u0019\u0001B9\u0003\rAH%M\u0001\tG\u0006tW)];bYR!!\u0011\u0012BH!\r\t%1R\u0005\u0004\u0005\u001b\u0013%a\u0002\"p_2,\u0017M\u001c\u0005\n\u0005\u0007+\u0013\u0011!a\u0001\u0005w\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!\u0011\rBK\u0011%\u0011\u0019IJA\u0001\u0002\u0004\u0011\t(\u0001\u0005iCND7i\u001c3f)\t\u0011\t(\u0001\u0005u_N#(/\u001b8h)\t\u0011\t'\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005\u0013\u0013\u0019\u000bC\u0005\u0003\u0004&\n\t\u00111\u0001\u0003|\u0005Q2)Y:tC:$'/Y\"vgR|W.\u00133f]RLG/\u001f#B\u001fB\u0011!pK\n\u0006W\t-&q\u0017\t\b\u0005[\u0013\u0019LX7z\u001b\t\u0011yKC\u0002\u00032\n\u000bqA];oi&lW-\u0003\u0003\u00036\n=&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!!\u0011\u0018B`\u001b\t\u0011YL\u0003\u0003\u0003>\nu\u0011AA5p\u0013\rQ&1\u0018\u000b\u0003\u0005O\u000bQ!\u00199qYf$R!\u001fBd\u0005\u0013DQ\u0001\u0018\u0018A\u0002yCQa\u001b\u0018A\u00025\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003P\n]\u0007#B!\u0002z\nE\u0007#B!\u0003Tzk\u0017b\u0001Bk\u0005\n1A+\u001e9mKJB\u0001B!70\u0003\u0003\u0005\r!_\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001Bp!\u0011\u0011\u0019G!9\n\t\t\r(Q\r\u0002\u0007\u001f\nTWm\u0019;")
public class CassandraCustomIdentityDAO
implements CustomIdentityDAO,
Product,
Serializable {
    private final Session session;
    private final CassandraTypesProvider typesProvider;
    private final CassandraAsyncExecutor executor;
    private final EmailAddressTupleUtil emailAddressTupleUtil;
    private final PreparedStatement insertStatement;
    private final PreparedStatement selectAllStatement;
    private final PreparedStatement selectOneStatement;
    private final PreparedStatement deleteOneStatement;

    public static Option<Tuple2<Session, CassandraTypesProvider>> unapply(CassandraCustomIdentityDAO x$0) {
        return CassandraCustomIdentityDAO$.MODULE$.unapply(x$0);
    }

    public static CassandraCustomIdentityDAO apply(Session session, CassandraTypesProvider typesProvider) {
        return CassandraCustomIdentityDAO$.MODULE$.apply(session, typesProvider);
    }

    public static Function1<Tuple2<Session, CassandraTypesProvider>, CassandraCustomIdentityDAO> tupled() {
        return CassandraCustomIdentityDAO$.MODULE$.tupled();
    }

    public static Function1<Session, Function1<CassandraTypesProvider, CassandraCustomIdentityDAO>> curried() {
        return CassandraCustomIdentityDAO$.MODULE$.curried();
    }

    public Iterator<Object> productIterator() {
        return Product.productIterator$((Product)this);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Session session() {
        return this.session;
    }

    public CassandraTypesProvider typesProvider() {
        return this.typesProvider;
    }

    public CassandraAsyncExecutor executor() {
        return this.executor;
    }

    public EmailAddressTupleUtil emailAddressTupleUtil() {
        return this.emailAddressTupleUtil;
    }

    public PreparedStatement insertStatement() {
        return this.insertStatement;
    }

    public PreparedStatement selectAllStatement() {
        return this.selectAllStatement;
    }

    public PreparedStatement selectOneStatement() {
        return this.selectOneStatement;
    }

    public PreparedStatement deleteOneStatement() {
        return this.deleteOneStatement;
    }

    public SMono<Identity> save(Username user, IdentityCreationRequest creationRequest) {
        return this.save(user, IdentityId$.MODULE$.generate(), creationRequest);
    }

    public SMono<Identity> save(Username user, IdentityId identityId, IdentityCreationRequest creationRequest) {
        return SMono$.MODULE$.just((Object)identityId).map((Function1 & Serializable)id -> creationRequest.asIdentity(id)).flatMap((Function1 & Serializable)identity -> this.insert(user, (Identity)identity));
    }

    public SFlux<Identity> list(Username user) {
        return SFlux$.MODULE$.fromPublisher((Publisher)this.executor().executeRows((Statement)this.selectAllStatement().bind().setString(CassandraCustomIdentityTable$.MODULE$.USER(), user.asString())).map(row -> this.toIdentity((Row)row)));
    }

    public SMono<Identity> findByIdentityId(Username user, IdentityId identityId) {
        return SMono$.MODULE$.fromPublisher((Publisher)this.executor().executeSingleRow((Statement)this.selectOneStatement().bind().setString(CassandraCustomIdentityTable$.MODULE$.USER(), user.asString()).setUUID(CassandraCustomIdentityTable$.MODULE$.ID(), identityId.id())).map(row -> this.toIdentity((Row)row)));
    }

    public SMono<BoxedUnit> update(Username user, IdentityId identityId, IdentityUpdate identityUpdate) {
        return SMono$.MODULE$.fromPublisher((Publisher)this.executor().executeSingleRow((Statement)this.selectOneStatement().bind().setString(CassandraCustomIdentityTable$.MODULE$.USER(), user.asString()).setUUID(CassandraCustomIdentityTable$.MODULE$.ID(), identityId.id())).switchIfEmpty(Mono.error(() -> new IdentityNotFoundException(identityId))).map(row -> this.toIdentity((Row)row)).map(identity -> identityUpdate.update(identity)).flatMap(patch -> this.insert(user, (Identity)patch).then().asJava()));
    }

    public SMono<BoxedUnit> upsert(Username user, Identity patch) {
        return this.insert(user, patch).then();
    }

    public SMono<BoxedUnit> delete(Username username, Seq<IdentityId> ids) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable(ids);
        Function1 & Serializable x$1 = (Function1 & Serializable)id -> this.executor().executeVoid((Statement)this.deleteOneStatement().bind().setString(CassandraCustomIdentityTable$.MODULE$.USER(), username.asString()).setUUID(CassandraCustomIdentityTable$.MODULE$.ID(), id.id()));
        int x$2 = qual$1.flatMap$default$2();
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        return qual$1.flatMap((Function1)x$1, x$2, x$3, x$4).then();
    }

    private SMono<Identity> insert(Username username, Identity identity) {
        BoundStatement insertIdentity = this.insertStatement().bind().setString(CassandraCustomIdentityTable$.MODULE$.USER(), username.asString()).setUUID(CassandraCustomIdentityTable$.MODULE$.ID(), identity.id().id()).setString(CassandraCustomIdentityTable$.MODULE$.NAME(), identity.name()).setString(CassandraCustomIdentityTable$.MODULE$.EMAIL(), identity.email().asString()).setString(CassandraCustomIdentityTable$.MODULE$.TEXT_SIGNATURE(), identity.textSignature()).setString(CassandraCustomIdentityTable$.MODULE$.HTML_SIGNATURE(), identity.htmlSignature()).setBool(CassandraCustomIdentityTable$.MODULE$.MAY_DELETE(), identity.mayDelete());
        identity.replyTo().map((Function1 & Serializable)listEmailAddress -> insertIdentity.setSet(CassandraCustomIdentityTable$.MODULE$.REPLY_TO(), this.toJavaSet((List<EmailAddress>)listEmailAddress)));
        identity.bcc().map((Function1 & Serializable)listEmailAddress -> insertIdentity.setSet(CassandraCustomIdentityTable$.MODULE$.BCC(), this.toJavaSet((List<EmailAddress>)listEmailAddress)));
        return SMono$.MODULE$.fromPublisher((Publisher)this.executor().executeVoid((Statement)insertIdentity).thenReturn((Object)identity));
    }

    private Identity toIdentity(Row row) {
        return new Identity(new IdentityId(row.getUUID(CassandraCustomIdentityTable$.MODULE$.ID())), row.getString(CassandraCustomIdentityTable$.MODULE$.NAME()), new MailAddress(row.getString(CassandraCustomIdentityTable$.MODULE$.EMAIL())), this.toReplyTo(row), this.toBcc(row), row.getString(CassandraCustomIdentityTable$.MODULE$.TEXT_SIGNATURE()), row.getString(CassandraCustomIdentityTable$.MODULE$.HTML_SIGNATURE()), row.getBool(CassandraCustomIdentityTable$.MODULE$.MAY_DELETE()));
    }

    private Option<List<EmailAddress>> toReplyTo(Row row) {
        return Option$.MODULE$.apply((Object)CollectionConverters$.MODULE$.asScala(row.getSet(CassandraCustomIdentityTable$.MODULE$.REPLY_TO(), UDTValue.class)).toList().map((Function1 & Serializable)udtValue -> this.toEmailAddress((UDTValue)udtValue)));
    }

    private Option<List<EmailAddress>> toBcc(Row row) {
        return Option$.MODULE$.apply((Object)CollectionConverters$.MODULE$.asScala(row.getSet(CassandraCustomIdentityTable$.MODULE$.BCC(), UDTValue.class)).toList().map((Function1 & Serializable)udtValue -> this.toEmailAddress((UDTValue)udtValue)));
    }

    private java.util.Set<UDTValue> toJavaSet(List<EmailAddress> listEmailAddress) {
        return CollectionConverters$.MODULE$.asJava((Set)listEmailAddress.map((Function1 & Serializable)emailAddress -> this.emailAddressTupleUtil().createEmailAddressUDT((Option<String>)emailAddress.name().map((Function1 & Serializable)name -> ((EmailerName)name).value()), emailAddress.email().asString())).toSet());
    }

    private EmailAddress toEmailAddress(UDTValue udtValue) {
        return new EmailAddress(Option$.MODULE$.apply((Object)udtValue.getString(CassandraCustomIdentityTable$EmailAddress$.MODULE$.NAME())).map((Function1 & Serializable)string -> new EmailerName(string)), new MailAddress(udtValue.getString(CassandraCustomIdentityTable$EmailAddress$.MODULE$.EMAIL())));
    }

    public CassandraCustomIdentityDAO copy(Session session, CassandraTypesProvider typesProvider) {
        return new CassandraCustomIdentityDAO(session, typesProvider);
    }

    public Session copy$default$1() {
        return this.session();
    }

    public CassandraTypesProvider copy$default$2() {
        return this.typesProvider();
    }

    public String productPrefix() {
        return "CassandraCustomIdentityDAO";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.session();
            }
            case 1: {
                return this.typesProvider();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CassandraCustomIdentityDAO;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "session";
            }
            case 1: {
                return "typesProvider";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CassandraCustomIdentityDAO)) return false;
        boolean bl = true;
        if (!bl) return false;
        CassandraCustomIdentityDAO cassandraCustomIdentityDAO = (CassandraCustomIdentityDAO)x$1;
        Session session = this.session();
        Session session2 = cassandraCustomIdentityDAO.session();
        if (session == null) {
            if (session2 != null) {
                return false;
            }
        } else if (!session.equals(session2)) return false;
        CassandraTypesProvider cassandraTypesProvider = this.typesProvider();
        CassandraTypesProvider cassandraTypesProvider2 = cassandraCustomIdentityDAO.typesProvider();
        if (cassandraTypesProvider == null) {
            if (cassandraTypesProvider2 != null) {
                return false;
            }
        } else if (!cassandraTypesProvider.equals(cassandraTypesProvider2)) return false;
        if (!cassandraCustomIdentityDAO.canEqual(this)) return false;
        return true;
    }

    @Inject
    public CassandraCustomIdentityDAO(Session session, CassandraTypesProvider typesProvider) {
        this.session = session;
        this.typesProvider = typesProvider;
        Product.$init$((Product)this);
        this.executor = new CassandraAsyncExecutor(session);
        this.emailAddressTupleUtil = new EmailAddressTupleUtil(typesProvider);
        this.insertStatement = session.prepare((RegularStatement)QueryBuilder.insertInto((String)CassandraCustomIdentityTable$.MODULE$.TABLE_NAME()).value(CassandraCustomIdentityTable$.MODULE$.USER(), (Object)QueryBuilder.bindMarker((String)CassandraCustomIdentityTable$.MODULE$.USER())).value(CassandraCustomIdentityTable$.MODULE$.ID(), (Object)QueryBuilder.bindMarker((String)CassandraCustomIdentityTable$.MODULE$.ID())).value(CassandraCustomIdentityTable$.MODULE$.NAME(), (Object)QueryBuilder.bindMarker((String)CassandraCustomIdentityTable$.MODULE$.NAME())).value(CassandraCustomIdentityTable$.MODULE$.EMAIL(), (Object)QueryBuilder.bindMarker((String)CassandraCustomIdentityTable$.MODULE$.EMAIL())).value(CassandraCustomIdentityTable$.MODULE$.REPLY_TO(), (Object)QueryBuilder.bindMarker((String)CassandraCustomIdentityTable$.MODULE$.REPLY_TO())).value(CassandraCustomIdentityTable$.MODULE$.BCC(), (Object)QueryBuilder.bindMarker((String)CassandraCustomIdentityTable$.MODULE$.BCC())).value(CassandraCustomIdentityTable$.MODULE$.TEXT_SIGNATURE(), (Object)QueryBuilder.bindMarker((String)CassandraCustomIdentityTable$.MODULE$.TEXT_SIGNATURE())).value(CassandraCustomIdentityTable$.MODULE$.HTML_SIGNATURE(), (Object)QueryBuilder.bindMarker((String)CassandraCustomIdentityTable$.MODULE$.HTML_SIGNATURE())).value(CassandraCustomIdentityTable$.MODULE$.MAY_DELETE(), (Object)QueryBuilder.bindMarker((String)CassandraCustomIdentityTable$.MODULE$.MAY_DELETE())));
        this.selectAllStatement = session.prepare((RegularStatement)QueryBuilder.select().from(CassandraCustomIdentityTable$.MODULE$.TABLE_NAME()).where(QueryBuilder.eq((String)CassandraCustomIdentityTable$.MODULE$.USER(), (Object)QueryBuilder.bindMarker((String)CassandraCustomIdentityTable$.MODULE$.USER()))));
        this.selectOneStatement = session.prepare((RegularStatement)QueryBuilder.select().from(CassandraCustomIdentityTable$.MODULE$.TABLE_NAME()).where(QueryBuilder.eq((String)CassandraCustomIdentityTable$.MODULE$.USER(), (Object)QueryBuilder.bindMarker((String)CassandraCustomIdentityTable$.MODULE$.USER()))).and(QueryBuilder.eq((String)CassandraCustomIdentityTable$.MODULE$.ID(), (Object)QueryBuilder.bindMarker((String)CassandraCustomIdentityTable$.MODULE$.ID()))));
        this.deleteOneStatement = session.prepare((RegularStatement)QueryBuilder.delete().from(CassandraCustomIdentityTable$.MODULE$.TABLE_NAME()).where(QueryBuilder.eq((String)CassandraCustomIdentityTable$.MODULE$.USER(), (Object)QueryBuilder.bindMarker((String)CassandraCustomIdentityTable$.MODULE$.USER()))).and(QueryBuilder.eq((String)CassandraCustomIdentityTable$.MODULE$.ID(), (Object)QueryBuilder.bindMarker((String)CassandraCustomIdentityTable$.MODULE$.ID()))));
    }
}

