/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.events;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Utf8Appendable;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BadPayloadException;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.frames.CloseFrame;
import org.eclipse.jetty.websocket.common.message.MessageAppender;

public abstract class AbstractEventDriver
extends AbstractLifeCycle
implements IncomingFrames,
EventDriver {
    private static final Logger LOG = Log.getLogger(AbstractEventDriver.class);
    protected final Logger targetLog;
    protected WebSocketPolicy policy;
    protected final Object websocket;
    protected WebSocketSession session;
    protected MessageAppender activeMessage;

    public AbstractEventDriver(WebSocketPolicy policy, Object websocket) {
        this.policy = policy;
        this.websocket = websocket;
        this.targetLog = Log.getLogger(websocket.getClass());
    }

    protected void appendMessage(ByteBuffer buffer, boolean fin) throws IOException {
        this.activeMessage.appendFrame(buffer, fin);
        if (fin) {
            this.activeMessage.messageComplete();
            this.activeMessage = null;
        }
    }

    protected void dispatch(Runnable runnable) {
        this.session.dispatch(runnable);
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public WebSocketSession getSession() {
        return this.session;
    }

    public void incomingFrame(Frame frame) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("incomingFrame({})", new Object[]{frame});
        }
        try {
            this.onFrame(frame);
            byte opcode = frame.getOpCode();
            switch (opcode) {
                case 8: {
                    boolean validate = true;
                    CloseFrame closeframe = (CloseFrame)frame;
                    CloseInfo close = new CloseInfo(closeframe, validate);
                    this.session.getConnection().remoteClose(close);
                    return;
                }
                case 9: {
                    ByteBuffer pongBuf;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("PING: {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)frame.getPayload())});
                    }
                    if (frame.hasPayload()) {
                        pongBuf = ByteBuffer.allocate(frame.getPayload().remaining());
                        BufferUtil.put((ByteBuffer)frame.getPayload().slice(), (ByteBuffer)pongBuf);
                        BufferUtil.flipToFlush((ByteBuffer)pongBuf, (int)0);
                    } else {
                        pongBuf = ByteBuffer.allocate(0);
                    }
                    this.onPing(frame.getPayload());
                    this.session.getRemote().sendPong(pongBuf);
                    break;
                }
                case 10: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("PONG: {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)frame.getPayload())});
                    }
                    this.onPong(frame.getPayload());
                    break;
                }
                case 2: {
                    this.onBinaryFrame(frame.getPayload(), frame.isFin());
                    return;
                }
                case 1: {
                    this.onTextFrame(frame.getPayload(), frame.isFin());
                    return;
                }
                case 0: {
                    this.onContinuationFrame(frame.getPayload(), frame.isFin());
                    return;
                }
                default: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Unhandled OpCode: {}", (long)opcode);
                    }
                    break;
                }
            }
        }
        catch (Utf8Appendable.NotUtf8Exception e) {
            this.session.close((Throwable)new BadPayloadException((Throwable)e));
        }
        catch (Throwable t) {
            this.session.close(t);
        }
    }

    @Override
    public void onContinuationFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (this.activeMessage == null) {
            throw new IOException("Out of order Continuation frame encountered");
        }
        this.appendMessage(buffer, fin);
    }

    @Override
    public void onPong(ByteBuffer buffer) {
    }

    @Override
    public void onPing(ByteBuffer buffer) {
    }

    @Override
    public BatchMode getBatchMode() {
        return null;
    }

    @Override
    public void openSession(WebSocketSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("openSession({})", new Object[]{session});
            LOG.debug("objectFactory={}", new Object[]{session.getContainerScope().getObjectFactory()});
        }
        this.session = session;
        this.session.getContainerScope().getObjectFactory().decorate(this.websocket);
        try {
            this.onConnect();
        }
        catch (Throwable t) {
            this.session.close(t);
        }
    }
}

