/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.metadata;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BucketName;
import org.apache.james.core.Username;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class UserPerBucketDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement addStatement;
    private final PreparedStatement removeStatement;
    private final PreparedStatement listStatement;
    private final PreparedStatement listBucketsStatement;

    @Inject
    UserPerBucketDAO(Session session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.addStatement = this.prepareAddUser(session);
        this.removeStatement = this.prepareRemoveBucket(session);
        this.listStatement = this.prepareListUser(session);
        this.listBucketsStatement = this.prepareListBuckets(session);
    }

    private PreparedStatement prepareAddUser(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"userPerBucket").value("bucketName", (Object)QueryBuilder.bindMarker((String)"bucketName")).value("user", (Object)QueryBuilder.bindMarker((String)"user")));
    }

    private PreparedStatement prepareRemoveBucket(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("userPerBucket").where(QueryBuilder.eq((String)"bucketName", (Object)QueryBuilder.bindMarker((String)"bucketName"))));
    }

    private PreparedStatement prepareListUser(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"user"}).from("userPerBucket").where(QueryBuilder.eq((String)"bucketName", (Object)QueryBuilder.bindMarker((String)"bucketName"))));
    }

    private PreparedStatement prepareListBuckets(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"bucketName"}).from("userPerBucket").perPartitionLimit(1));
    }

    Flux<Username> retrieveUsers(BucketName bucketName) {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.listStatement.bind().setString("bucketName", bucketName.asString())).map(row -> row.getString("user")).map(Username::of);
    }

    Flux<BucketName> retrieveBuckets() {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.listBucketsStatement.bind()).map(row -> row.getString("bucketName")).map(BucketName::of);
    }

    Mono<Void> addUser(BucketName bucketName, Username username) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.addStatement.bind().setString("bucketName", bucketName.asString()).setString("user", username.asString()));
    }

    Mono<Void> deleteBucket(BucketName bucketName) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.removeStatement.bind().setString("bucketName", bucketName.asString()));
    }
}

