/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.metadata;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import org.apache.james.backends.cassandra.components.CassandraModule;

public interface DeletedMessageMetadataModule {
    public static final CassandraModule MODULE = CassandraModule.builder().table("storageInformation").comment("Holds storage information for deleted messages in the BlobStore based DeletedMessages vault").options(options -> (Create.Options)options.caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.noRows())).statement(statement -> (Create)((Create)statement.addPartitionKey("owner", DataType.text()).addPartitionKey("messageId", DataType.text()).addColumn("bucketName", DataType.text())).addColumn("blobId", DataType.text())).table("userPerBucket").comment("Holds user list having deletedMessages stored in a given bucket in the BlobStore based DeletedMessages vault").options(options -> (Create.Options)options.caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.noRows())).statement(statement -> statement.addPartitionKey("bucketName", DataType.text()).addClusteringColumn("user", DataType.text())).table("deletedMessageMetadata").comment("Holds storage information for deleted messages in the BlobStore based DeletedMessages vault").options(options -> (Create.Options)options.caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.noRows())).statement(statement -> (Create)statement.addPartitionKey("bucketName", DataType.text()).addPartitionKey("owner", DataType.text()).addClusteringColumn("messageId", DataType.text()).addColumn("payload", DataType.text())).build();

    public static interface DeletedMessageMetadataTable {
        public static final String TABLE = "deletedMessageMetadata";
        public static final String BUCKET_NAME = "bucketName";
        public static final String OWNER = "owner";
        public static final String MESSAGE_ID = "messageId";
        public static final String PAYLOAD = "payload";
    }

    public static interface UserPerBucketTable {
        public static final String TABLE = "userPerBucket";
        public static final String BUCKET_NAME = "bucketName";
        public static final String USER = "user";
    }

    public static interface StorageInformationTable {
        public static final String TABLE = "storageInformation";
        public static final String OWNER = "owner";
        public static final String MESSAGE_ID = "messageId";
        public static final String BUCKET_NAME = "bucketName";
        public static final String BLOB_ID = "blobId";
    }
}

