/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jgroups.Address;
import org.jgroups.Global;
import org.jgroups.util.AverageMinMax;

public class RpcStats {
    protected final AtomicInteger sync_unicasts = new AtomicInteger(0);
    protected final AtomicInteger async_unicasts = new AtomicInteger(0);
    protected final AtomicInteger sync_multicasts = new AtomicInteger(0);
    protected final AtomicInteger async_multicasts = new AtomicInteger(0);
    protected final AtomicInteger sync_anycasts = new AtomicInteger(0);
    protected final AtomicInteger async_anycasts = new AtomicInteger(0);
    protected volatile ConcurrentMap<Address, Result> stats;

    public RpcStats(boolean extended_stats) {
        this.extendedStats(extended_stats);
    }

    public int unicasts(boolean sync) {
        return sync ? this.sync_unicasts.get() : this.async_unicasts.get();
    }

    public int multicasts(boolean sync) {
        return sync ? this.sync_multicasts.get() : this.async_multicasts.get();
    }

    public int anycasts(boolean sync) {
        return sync ? this.sync_anycasts.get() : this.async_anycasts.get();
    }

    public boolean extendedStats() {
        return this.stats != null;
    }

    public RpcStats extendedStats(boolean f) {
        if (f) {
            if (this.stats == null) {
                this.stats = new ConcurrentHashMap<Address, Result>();
            }
        } else {
            this.stats = null;
        }
        return this;
    }

    public void reset() {
        if (this.stats != null) {
            this.stats.clear();
        }
        for (AtomicInteger ai : Arrays.asList(this.sync_unicasts, this.async_unicasts, this.sync_multicasts, this.async_multicasts, this.sync_anycasts, this.async_anycasts)) {
            ai.set(0);
        }
    }

    public void add(Type type, Address dest, boolean sync, long time) {
        this.update(type, sync);
        this.addToResults(dest, sync, time);
    }

    public void addAnycast(boolean sync, long time, Collection<Address> dests) {
        this.update(Type.ANYCAST, sync);
        if (dests != null) {
            for (Address dest : dests) {
                this.addToResults(dest, sync, time);
            }
        }
    }

    public void retainAll(Collection<Address> members) {
        ConcurrentMap<Address, Result> map;
        if (members == null || (map = this.stats) == null) {
            return;
        }
        map.keySet().retainAll(members);
    }

    public String printOrderByDest() {
        if (this.stats == null) {
            return "(no stats)";
        }
        StringBuilder sb = new StringBuilder("\n");
        for (Map.Entry entry : this.stats.entrySet()) {
            Address dst = (Address)entry.getKey();
            sb.append(String.format("%s: %s\n", dst == Global.NULL_ADDRESS ? "<all>" : dst, entry.getValue()));
        }
        return sb.toString();
    }

    public String toString() {
        return String.format("sync mcasts: %d, async mcasts: %d, sync ucasts: %d, async ucasts: %d, sync acasts: %d, async acasts: %d", this.sync_multicasts.get(), this.async_multicasts.get(), this.sync_unicasts.get(), this.async_unicasts.get(), this.sync_anycasts.get(), this.async_anycasts.get());
    }

    protected void update(Type type, boolean sync) {
        switch (type) {
            case MULTICAST: {
                if (sync) {
                    this.sync_multicasts.incrementAndGet();
                    break;
                }
                this.async_multicasts.incrementAndGet();
                break;
            }
            case UNICAST: {
                if (sync) {
                    this.sync_unicasts.incrementAndGet();
                    break;
                }
                this.async_unicasts.incrementAndGet();
                break;
            }
            case ANYCAST: {
                if (sync) {
                    this.sync_anycasts.incrementAndGet();
                    break;
                }
                this.async_anycasts.incrementAndGet();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("type %s is invalid", new Object[]{type}));
            }
        }
    }

    protected void addToResults(Address dest, boolean sync, long time) {
        Result tmp;
        Result res;
        ConcurrentMap<Address, Result> map = this.stats;
        if (map == null) {
            return;
        }
        if (dest == null) {
            dest = Global.NULL_ADDRESS;
        }
        if ((res = (Result)map.get(dest)) == null && (tmp = map.putIfAbsent(dest, res = new Result())) != null) {
            res = tmp;
        }
        res.add(sync, time);
    }

    protected static class Result {
        protected long sync;
        protected long async;
        protected final AverageMinMax avg = new AverageMinMax();

        protected Result() {
        }

        protected long sync() {
            return this.sync;
        }

        protected long async() {
            return this.async;
        }

        protected long min() {
            return this.avg.min();
        }

        protected long max() {
            return this.avg.max();
        }

        protected synchronized double avg() {
            return this.avg.average();
        }

        protected synchronized void add(boolean sync, long time) {
            if (sync) {
                ++this.sync;
            } else {
                ++this.async;
            }
            if (time > 0L) {
                this.avg.add(time);
            }
        }

        public String toString() {
            double avg_us = this.avg() / 1000.0;
            double min_us = (double)this.avg.min() / 1000.0;
            double max_us = (double)this.avg.max() / 1000.0;
            return String.format("async: %d, sync: %d, round-trip min/avg/max (us): %.2f / %.2f / %.2f", this.async, this.sync, min_us, avg_us, max_us);
        }
    }

    public static enum Type {
        MULTICAST,
        UNICAST,
        ANYCAST;

    }
}

